/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.TimeZone;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.SupplierHelper;
import org.simpleflatmapper.util.date.DateFormatSupplier;
import org.simpleflatmapper.util.date.DefaultDateFormatSupplier;

public final class JavaTimeHelper {
    private JavaTimeHelper() {
    }

    public static DateTimeFormatter getDateTimeFormatter(Object ... properties) {
        ZoneId zoneId = JavaTimeHelper.getZoneId(properties);
        DefaultDateFormatSupplier defaultDateFormatSupplier = null;
        for (Object prop : properties) {
            DateTimeFormatter dateTimeFormatter = JavaTimeHelper.toDateTimeFormatter(prop, zoneId);
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            if (!(prop instanceof DefaultDateFormatSupplier)) continue;
            defaultDateFormatSupplier = (DefaultDateFormatSupplier)prop;
        }
        if (defaultDateFormatSupplier != null) {
            return JavaTimeHelper.withZone(defaultDateFormatSupplier.get(), zoneId);
        }
        return null;
    }

    public static DateTimeFormatter[] getDateTimeFormatters(Object ... properties) {
        ArrayList<DateTimeFormatter> dtf = new ArrayList<DateTimeFormatter>();
        ZoneId zoneId = JavaTimeHelper.getZoneId(properties);
        DefaultDateFormatSupplier defaultDateFormatSupplier = null;
        for (Object prop : properties) {
            DateTimeFormatter dateTimeFormatter = JavaTimeHelper.toDateTimeFormatter(prop, zoneId);
            if (dateTimeFormatter != null) {
                dtf.add(dateTimeFormatter);
                continue;
            }
            if (!(prop instanceof DefaultDateFormatSupplier)) continue;
            defaultDateFormatSupplier = (DefaultDateFormatSupplier)prop;
        }
        if (dtf.isEmpty()) {
            if (defaultDateFormatSupplier == null) {
                throw new IllegalStateException("No date format specified");
            }
            dtf.add(JavaTimeHelper.withZone(defaultDateFormatSupplier.get(), zoneId));
        }
        return dtf.toArray(new DateTimeFormatter[0]);
    }

    private static DateTimeFormatter toDateTimeFormatter(Object prop, ZoneId zoneId) {
        if (SupplierHelper.isSupplierOf((Object)prop, DateTimeFormatter.class)) {
            return JavaTimeHelper.withZone((DateTimeFormatter)((Supplier)prop).get(), zoneId);
        }
        if (prop instanceof DateFormatSupplier) {
            return JavaTimeHelper.withZone(((DateFormatSupplier)prop).get(), zoneId);
        }
        if (prop instanceof DateTimeFormatter) {
            return (DateTimeFormatter)prop;
        }
        return null;
    }

    private static DateTimeFormatter withZone(String format, ZoneId zoneId) {
        return JavaTimeHelper.withZone(DateTimeFormatter.ofPattern(format), zoneId);
    }

    private static DateTimeFormatter withZone(DateTimeFormatter dateTimeFormatter, ZoneId zoneId) {
        if (zoneId != null) {
            return dateTimeFormatter.withZone(zoneId);
        }
        if (dateTimeFormatter.getZone() == null) {
            return dateTimeFormatter.withZone(ZoneId.systemDefault());
        }
        return dateTimeFormatter;
    }

    public static ZoneId getZoneIdOrDefault(Object ... params) {
        ZoneId p = JavaTimeHelper.getZoneId(params);
        if (p != null) {
            return p;
        }
        return ZoneId.systemDefault();
    }

    public static ZoneId getZoneId(Object[] params) {
        if (params != null) {
            for (Object p : params) {
                if (p instanceof ZoneId) {
                    return (ZoneId)p;
                }
                if (p instanceof TimeZone) {
                    return ((TimeZone)p).toZoneId();
                }
                if (SupplierHelper.isSupplierOf((Object)p, ZoneId.class)) {
                    return (ZoneId)((Supplier)p).get();
                }
                if (!SupplierHelper.isSupplierOf((Object)p, TimeZone.class)) continue;
                return ((TimeZone)((Supplier)p).get()).toZoneId();
            }
        }
        return null;
    }
}

