/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hugegraph.computer.algorithm.AlgorithmParams;
import org.apache.hugegraph.computer.core.allocator.Allocator;
import org.apache.hugegraph.computer.core.allocator.DefaultAllocator;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.config.DefaultConfig;
import org.apache.hugegraph.computer.core.graph.BuiltinGraphFactory;
import org.apache.hugegraph.computer.core.graph.GraphFactory;

public class ComputerContextUtil {
    public static Config initContext(Map<String, String> params) {
        AlgorithmParams algorithmParams;
        String algorithmParamsName = params.get(ComputerOptions.ALGORITHM_PARAMS_CLASS.name());
        try {
            algorithmParams = (AlgorithmParams)Class.forName(algorithmParamsName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ComputerException("Can't create algorithmParams, algorithmParamsName = %s", new Object[]{algorithmParamsName});
        }
        algorithmParams.setAlgorithmParameters(params);
        DefaultConfig config = new DefaultConfig(params);
        BuiltinGraphFactory graphFactory = new BuiltinGraphFactory();
        DefaultAllocator allocator = new DefaultAllocator((Config)config, graphFactory);
        ComputerContext.initContext((Config)config, (GraphFactory)graphFactory, (Allocator)allocator);
        return config;
    }

    public static void initContext(Properties properties) {
        ComputerContextUtil.initContext(ComputerContextUtil.convertToMap(properties));
    }

    public static Map<String, String> convertToMap(String ... options) {
        if (options == null || options.length == 0) {
            throw new ComputerException("Config options can't be null or empty");
        }
        if ((options.length & 1) == 1) {
            throw new ComputerException("Config options length must be even");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < options.length; i += 2) {
            map.put(options[i], options[i + 1]);
        }
        return map;
    }

    public static Map<String, String> convertToMap(Properties properties) {
        if (properties == null) {
            throw new ComputerException("Properties can't be null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : properties.stringPropertyNames()) {
            map.put(key, properties.getProperty(key));
        }
        return map;
    }
}

