/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.hgkvfile.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFile;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.HgkvFileImpl;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.BlockBuilder;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.DataBlockBuilderImpl;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.HgkvFileBuilder;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.IndexBlockBuilder;
import org.apache.hugegraph.computer.core.store.file.hgkvfile.builder.IndexBlockBuilderImpl;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class HgkvFileBuilderImpl
implements HgkvFileBuilder {
    private final long maxDataBlockSize;
    private final HgkvFile file;
    private final RandomAccessOutput output;
    private final BlockBuilder dataBlockBuilder;
    private final IndexBlockBuilder indexBlockBuilder;
    private boolean buildFinished;
    private final List<byte[]> indexBlock;
    private long numEntries;
    private long numSubEntries;
    private long dataLength;
    private int footerLength;
    private long maxKeyOffset;
    private final long minKeyOffset;

    public HgkvFileBuilderImpl(Config config, String path) throws IOException {
        this.maxDataBlockSize = (Long)config.get((TypedOption)ComputerOptions.HGKV_DATABLOCK_SIZE);
        this.file = HgkvFileImpl.create(path);
        this.output = this.file.output();
        this.dataBlockBuilder = new DataBlockBuilderImpl(this.output);
        this.indexBlockBuilder = new IndexBlockBuilderImpl(this.output);
        this.buildFinished = false;
        this.dataLength = 0L;
        this.indexBlock = new ArrayList<byte[]>();
        this.numEntries = 0L;
        this.numSubEntries = 0L;
        this.footerLength = 0;
        this.maxKeyOffset = 0L;
        this.minKeyOffset = 0L;
    }

    @Override
    public void add(KvEntry entry) throws IOException {
        E.checkState((!this.buildFinished ? 1 : 0) != 0, (String)"Failed to write entry, builder is finished", (Object[])new Object[0]);
        E.checkArgument((entry != null ? 1 : 0) != 0, (String)"Parameter entry can't be null", (Object[])new Object[0]);
        this.blockAddEntry(entry);
        this.changeMetaAfterAdd(entry);
    }

    @Override
    public long sizeOfEntry(KvEntry entry) {
        long keySize = 4L + entry.key().length();
        long valueSize = 4L + entry.value().length();
        return keySize + valueSize;
    }

    @Override
    public void finish() throws IOException {
        if (this.buildFinished) {
            return;
        }
        this.dataBlockBuilder.finish();
        this.writeIndexBlock();
        this.writeFooter();
        this.output.close();
        this.file.close();
        this.buildFinished = true;
    }

    @Override
    public long dataLength() {
        return this.dataLength;
    }

    @Override
    public long indexLength() {
        return this.indexBlockBuilder.length();
    }

    @Override
    public int headerLength() {
        return this.footerLength;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    private void changeMetaAfterAdd(KvEntry entry) {
        ++this.numEntries;
        this.numSubEntries += entry.numSubEntries();
        this.maxKeyOffset = this.dataLength;
        this.dataLength += this.sizeOfEntry(entry);
    }

    private void blockAddEntry(KvEntry entry) throws IOException {
        long blockSize;
        long entrySize = this.dataBlockBuilder.sizeOfEntry(entry);
        if (entrySize + (blockSize = this.dataBlockBuilder.size()) >= this.maxDataBlockSize) {
            this.dataBlockBuilder.finish();
            this.dataBlockBuilder.reset();
            this.indexBlock.add(entry.key().bytes());
        }
        this.dataBlockBuilder.add(entry);
    }

    private void writeIndexBlock() throws IOException {
        for (byte[] index : this.indexBlock) {
            this.indexBlockBuilder.add(index);
        }
        this.indexBlockBuilder.finish();
    }

    private void writeFooter() throws IOException {
        long startPostion = this.output.position();
        this.output.writeBytes(HgkvFileImpl.MAGIC);
        this.output.writeLong(this.numEntries);
        this.output.writeLong(this.numSubEntries);
        this.output.writeLong(this.dataLength);
        this.output.writeLong(this.indexLength());
        this.output.writeLong(this.maxKeyOffset);
        this.output.writeLong(this.minKeyOffset);
        this.output.writeShort((int)HgkvFileImpl.MAJOR_VERSION);
        this.output.writeShort((int)HgkvFileImpl.MINOR_VERSION);
        this.footerLength = (int)(this.output.position() - startPostion);
        this.footerLength += 4;
        this.output.writeFixedInt(this.footerLength);
    }
}

