/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sort.merge;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.merge.FileMerger;
import org.apache.hugegraph.computer.core.sort.sorter.InputsSorterImpl;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileWriter;
import org.apache.hugegraph.computer.core.util.FileUtil;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public class FileMergerImpl
implements FileMerger {
    private final int mergePathNum;
    private final String tempDir;

    public FileMergerImpl(Config config) {
        this.mergePathNum = (Integer)config.get((TypedOption)ComputerOptions.HGKV_MERGE_FILES_NUM);
        this.tempDir = (String)config.get((TypedOption)ComputerOptions.HGKV_TEMP_DIR) + File.separator + UUID.randomUUID();
        boolean result = new File(this.tempDir).mkdirs();
        E.checkState((boolean)result, (String)"Failed to create temp directory: '%s'", (Object[])new Object[]{this.tempDir});
    }

    @Override
    public void merge(List<String> inputs, Function<String, EntryIterator> inputToEntries, String output, Function<String, KvEntryFileWriter> fileToWriter, OuterSortFlusher flusher) throws Exception {
        ArrayList<String> subInputs = new ArrayList<String>(this.mergePathNum);
        int round = 0;
        while (inputs.size() > this.mergePathNum) {
            ArrayList<String> newInputs = new ArrayList<String>(inputs.size());
            for (int i = 0; i < inputs.size(); ++i) {
                subInputs.add(inputs.get(i));
                if (subInputs.size() != this.mergePathNum && i != inputs.size() - 1) continue;
                String subOutput = this.mergeInputsToRandomFile(subInputs, inputToEntries, fileToWriter, flusher);
                if (round != 0) {
                    FileUtil.deleteFilesQuietly(subInputs);
                }
                subInputs.clear();
                newInputs.add(subOutput);
            }
            inputs = newInputs;
            ++round;
        }
        this.mergeInputs(inputs, inputToEntries, flusher, output, fileToWriter);
    }

    private String mergeInputsToRandomFile(List<String> inputs, Function<String, EntryIterator> inputToIter, Function<String, KvEntryFileWriter> fileToWriter, OuterSortFlusher flusher) throws Exception {
        String output = this.randomPath();
        this.mergeInputs(inputs, inputToIter, flusher, output, fileToWriter);
        return output;
    }

    private void mergeInputs(List<String> inputs, Function<String, EntryIterator> inputToIter, OuterSortFlusher flusher, String output, Function<String, KvEntryFileWriter> fileToWriter) throws Exception {
        List<EntryIterator> entries = inputs.stream().map(inputToIter).collect(Collectors.toList());
        InputsSorterImpl sorter = new InputsSorterImpl();
        try (EntryIterator sortedKv = sorter.sort(entries);
             KvEntryFileWriter builder = fileToWriter.apply(output);){
            flusher.flush(sortedKv, builder);
        }
    }

    private String randomPath() {
        return this.tempDir + File.separator + "hgkv_" + UUID.randomUUID() + ".hgkv";
    }
}

