/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.GraphComputeOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessOutput;
import org.apache.hugegraph.computer.core.io.StreamGraphOutput;
import org.apache.hugegraph.computer.core.store.entry.EntryOutputImpl;

class WriteBuffer {
    private final int threshold;
    private final BytesOutput bytesOutput;
    private final GraphComputeOutput graphOutput;
    private long writeCount;

    public WriteBuffer(ComputerContext context, int threshold, int capacity) {
        assert (threshold > 0 && capacity > 0 && threshold <= capacity);
        this.threshold = threshold;
        this.bytesOutput = IOFactory.createBytesOutput(capacity);
        EntryOutputImpl entryOutput = new EntryOutputImpl((RandomAccessOutput)this.bytesOutput);
        this.graphOutput = new StreamGraphOutput(context, entryOutput);
        this.writeCount = 0L;
    }

    public boolean reachThreshold() {
        return this.bytesOutput.position() >= (long)this.threshold;
    }

    public boolean isEmpty() {
        return this.bytesOutput.position() == 0L;
    }

    public long numBytes() {
        return this.bytesOutput.position();
    }

    public long writeCount() {
        return this.writeCount;
    }

    public void clear() throws IOException {
        this.writeCount = 0L;
        this.bytesOutput.seek(0L);
    }

    public BytesOutput output() {
        return this.bytesOutput;
    }

    public void writeVertex(Vertex vertex) throws IOException {
        ++this.writeCount;
        this.graphOutput.writeVertex(vertex);
    }

    public void writeEdges(Vertex vertex) throws IOException {
        ++this.writeCount;
        this.graphOutput.writeEdges(vertex);
    }

    public void writeMessage(Id targetId, Value value) throws IOException {
        ++this.writeCount;
        this.graphOutput.writeMessage(targetId, value);
    }
}

