/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.output.hdfs.HdfsOutput;
import org.apache.hugegraph.config.TypedOption;

public class HdfsOutputMerger {
    private FileSystem fs;
    private Path[] sourcePaths;
    private Path mergedPath;
    private static final String MERGED_FILE_NAME = "all.csv";

    protected HdfsOutputMerger() {
    }

    protected void init(Config config) {
        try {
            Configuration configuration = new Configuration();
            this.fs = HdfsOutput.openHDFS(config, configuration);
            String dir = (String)config.get((TypedOption)ComputerOptions.OUTPUT_HDFS_DIR);
            String jobId = (String)config.get((TypedOption)ComputerOptions.JOB_ID);
            int partitions = (Integer)config.get((TypedOption)ComputerOptions.JOB_PARTITIONS_COUNT);
            this.sourcePaths = this.paths(dir, jobId, partitions);
            this.mergedPath = new Path(new Path(dir, jobId), MERGED_FILE_NAME);
        }
        catch (Exception e) {
            throw new ComputerException("Failed to init hdfs output merger", (Throwable)e);
        }
    }

    protected void merge() {
        try {
            this.fs.create(this.mergedPath, true).close();
            this.fs.concat(this.mergedPath, this.sourcePaths);
        }
        catch (IOException e) {
            throw new ComputerException("Failed to merge hdfs output files", (Throwable)e);
        }
    }

    private Path[] paths(String dir, String jobId, int partitions) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int i = 0; i < partitions; ++i) {
            Path path = HdfsOutput.buildPath(dir, jobId, i);
            if (!this.fs.exists(path) || this.fs.getFileStatus(path).getLen() <= 0L) continue;
            pathList.add(path);
        }
        return pathList.toArray(new Path[0]);
    }

    protected void close() {
        try {
            if (this.fs != null) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            throw new ComputerException("Failed to close hdfs output merger", (Throwable)e);
        }
    }
}

