/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.network.message.Message;

@ChannelHandler.Sharable
public class MessageEncoder
extends ChannelOutboundHandlerAdapter {
    public static final MessageEncoder INSTANCE = new MessageEncoder();

    private MessageEncoder() {
    }

    public void write(ChannelHandlerContext ctx, Object obj, ChannelPromise promise) throws Exception {
        if (obj instanceof Message) {
            Message message = (Message)obj;
            this.writeMessage(ctx, message, promise, ctx.alloc());
        } else {
            ctx.write(obj, promise);
        }
    }

    private void writeMessage(ChannelHandlerContext ctx, Message message, ChannelPromise promise, ByteBufAllocator allocator) throws TransportException {
        ByteBuf bufHeader = null;
        try {
            PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
            bufHeader = allocator.directBuffer(16);
            NetworkBuffer bodyBuffer = message.encode(bufHeader);
            ChannelFuture headerWriteFuture = ctx.write((Object)bufHeader);
            bufHeader = null;
            combiner.add((Future)headerWriteFuture);
            if (bodyBuffer != null) {
                ByteBuf bodyBuf = bodyBuffer.nettyByteBuf();
                bodyBuffer.retain();
                combiner.add((Future)ctx.write((Object)bodyBuf));
            }
            combiner.finish((Promise)promise);
        }
        catch (Throwable e) {
            throw new TransportException("Failed to encode message, message type: %s", e, new Object[]{message.type()});
        }
        finally {
            if (bufHeader != null) {
                bufHeader.release();
            }
            message.release();
        }
    }
}

