/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollMode;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.apache.hugegraph.computer.core.common.exception.IllegalArgException;
import org.apache.hugegraph.computer.core.network.IOMode;

public class NettyEventLoopUtil {
    private static ThreadFactory createNamedThreadFactory(String prefix) {
        return new DefaultThreadFactory(prefix, true);
    }

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String prefix) {
        ThreadFactory threadFactory = NettyEventLoopUtil.createNamedThreadFactory(prefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgException("Unknown io mode: " + mode);
    }

    public static Class<? extends Channel> clientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgException("Unknown io mode: " + mode);
    }

    public static Class<? extends ServerChannel> serverChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgException("Unknown io mode: " + mode);
    }

    public static void enableTriggeredMode(IOMode ioMode, boolean enableLt, ServerBootstrap serverBootstrap) {
        if (serverBootstrap == null || ioMode != IOMode.EPOLL) {
            return;
        }
        if (enableLt) {
            serverBootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.LEVEL_TRIGGERED);
        } else {
            serverBootstrap.childOption(EpollChannelOption.EPOLL_MODE, (Object)EpollMode.EDGE_TRIGGERED);
        }
    }
}

