/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.message;

import io.netty.buffer.ByteBuf;
import org.apache.hugegraph.computer.core.network.buffer.FileRegionBuffer;
import org.apache.hugegraph.computer.core.network.buffer.NettyBuffer;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.network.message.AbstractMessage;
import org.apache.hugegraph.computer.core.network.message.MessageType;
import org.apache.hugegraph.computer.core.network.message.RequestMessage;
import org.apache.hugegraph.util.E;

public class DataMessage
extends AbstractMessage
implements RequestMessage {
    private final MessageType type;

    public DataMessage(MessageType type, int requestId, int partition, NetworkBuffer data) {
        super(requestId, partition, data);
        E.checkArgument((requestId > 0 ? 1 : 0) != 0, (String)"The data requestId must be > 0, but got %s", (Object[])new Object[]{requestId});
        this.type = type;
    }

    @Override
    public MessageType type() {
        return this.type;
    }

    public static DataMessage parseWithMemoryBuffer(MessageType type, ByteBuf buf) {
        int requestId = buf.readInt();
        int partition = buf.readInt();
        int bodyLength = buf.readInt();
        ByteBuf bodySlice = buf.readRetainedSlice(bodyLength);
        NettyBuffer networkBuffer = new NettyBuffer(bodySlice);
        return new DataMessage(type, requestId, partition, networkBuffer);
    }

    public static DataMessage parseWithFileRegion(MessageType type, ByteBuf buf) {
        int requestId = buf.readInt();
        int partition = buf.readInt();
        int bodyLength = buf.readInt();
        return new DataMessage(type, requestId, partition, new FileRegionBuffer(bodyLength));
    }
}

