/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network;

import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.network.ClientHandler;
import org.apache.hugegraph.computer.core.network.ConnectionId;
import org.apache.hugegraph.computer.core.network.TransportClient;
import org.apache.hugegraph.computer.core.network.connection.ConnectionManager;
import org.apache.hugegraph.computer.core.sender.QueuedMessageSender;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class DataClientManager
implements Manager {
    public static final Logger LOG = Log.logger(DataClientManager.class);
    public static final String NAME = "data_client";
    private final ConnectionManager connManager;
    private final QueuedMessageSender sender;

    public DataClientManager(ConnectionManager connManager, ComputerContext context) {
        this.connManager = connManager;
        this.sender = new QueuedMessageSender(context.config());
    }

    public QueuedMessageSender sender() {
        return this.sender;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        DataClientHandler clientHandler = new DataClientHandler(this.sender.notBusyNotifier());
        this.connManager.initClientManager(config, clientHandler);
        LOG.info("DataClientManager inited");
    }

    @Override
    public void inited(Config config) {
        this.sender.init();
    }

    @Override
    public void close(Config config) {
        try {
            this.sender.close();
        }
        finally {
            this.connManager.shutdownClients();
        }
        LOG.info("DataClientManager closed");
    }

    public void connect(int workerId, String hostname, int dataPort) {
        try {
            TransportClient client = this.connManager.getOrCreateClient(hostname, dataPort);
            LOG.info("Successfully connect to worker: {}({}:{})", new Object[]{workerId, hostname, dataPort});
            this.sender.addWorkerClient(workerId, client);
        }
        catch (TransportException e) {
            throw new ComputerException("Failed to connect to worker: %s(%s:%s)", new Object[]{workerId, hostname, dataPort});
        }
    }

    private class DataClientHandler
    implements ClientHandler {
        private final Runnable notBusyNotifier;

        public DataClientHandler(Runnable notBusyNotifier) {
            E.checkNotNull((Object)notBusyNotifier, (String)"The not-busy notifier can't be null");
            this.notBusyNotifier = notBusyNotifier;
        }

        @Override
        public void sendAvailable(ConnectionId connectionId) {
            LOG.debug("Channel for connectionId {} is available", (Object)connectionId);
            this.notBusyNotifier.run();
        }

        @Override
        public void onChannelActive(ConnectionId connectionId) {
            LOG.debug("Channel for connectionId {} is active", (Object)connectionId);
        }

        @Override
        public void onChannelInactive(ConnectionId connectionId) {
            LOG.debug("Channel for connectionId {} is inactive", (Object)connectionId);
        }

        @Override
        public void exceptionCaught(TransportException cause, ConnectionId connectionId) {
            LOG.error("Channel for connectionId {} occurred exception", (Object)connectionId, (Object)cause);
            DataClientManager.this.connManager.closeClient(connectionId);
        }
    }
}

