/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.hugegraph.computer.core.io.AbstractBufferedFileInput;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.E;

public class BufferedFileInput
extends AbstractBufferedFileInput {
    private final int bufferCapacity;
    private final RandomAccessFile file;

    public BufferedFileInput(File file) throws IOException {
        this(new RandomAccessFile(file, "r"), 8192);
    }

    public BufferedFileInput(RandomAccessFile file, int bufferCapacity) throws IOException {
        super(bufferCapacity, file.length());
        E.checkArgument((bufferCapacity >= 8 ? 1 : 0) != 0, (String)"The parameter bufferSize must be >= 8", (Object[])new Object[0]);
        this.file = file;
        this.bufferCapacity = bufferCapacity;
        this.fillBuffer();
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int remaining = super.remaining();
        if (len <= remaining) {
            super.readFully(b, off, len);
        } else if (len <= this.bufferCapacity) {
            this.shiftAndFillBuffer();
            super.readFully(b, off, len);
        } else {
            super.readFully(b, off, remaining);
            this.file.readFully(b, off + remaining, len -= remaining);
            this.fileOffset += (long)len;
        }
    }

    @Override
    public void seek(long position) throws IOException {
        if (position == this.position()) {
            return;
        }
        long bufferStart = this.fileOffset - (long)this.limit();
        if (position >= bufferStart && position < this.fileOffset) {
            super.seek(position - bufferStart);
            return;
        }
        if (position > this.fileLength()) {
            throw new EOFException(String.format("Can't seek to %s, reach the end of file", position));
        }
        this.file.seek(position);
        super.seek(0L);
        this.limit(0);
        this.fileOffset = position;
        this.fillBuffer();
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    protected void fillBuffer() throws IOException {
        int readLen = (int)Math.min((long)(this.bufferCapacity - this.limit()), this.fileLength() - this.fileOffset);
        this.fileOffset += (long)readLen;
        this.file.readFully(this.buffer(), this.limit(), readLen);
        this.limit(this.limit() + readLen);
    }

    @Override
    public BufferedFileInput duplicate() throws IOException {
        String path = (String)Whitebox.getInternalState((Object)this.file, (String)"path");
        BufferedFileInput input = new BufferedFileInput(new File(path));
        input.seek(this.position());
        return input;
    }
}

