/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.hg;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.ElementFetcher;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.structure.graph.Shard;

public abstract class HugeElementFetcher<T>
implements ElementFetcher<T> {
    private final Config config;
    private final HugeClient client;
    private Iterator<T> localBatch;
    private T next;

    public HugeElementFetcher(Config config, HugeClient client) {
        this.config = config;
        this.client = client;
    }

    protected Config config() {
        return this.config;
    }

    protected HugeClient client() {
        return this.client;
    }

    protected int pageSize() {
        return (Integer)this.config.get((TypedOption)ComputerOptions.INPUT_SPLIT_PAGE_SIZE);
    }

    @Override
    public void prepareLoadInputSplit(InputSplit split) {
        this.localBatch = this.fetch(split);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.localBatch != null && this.localBatch.hasNext()) {
            this.next = this.localBatch.next();
            return true;
        }
        this.localBatch = null;
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T current = this.next;
        this.next = null;
        return current;
    }

    public abstract Iterator<T> fetch(InputSplit var1);

    public static Shard toShard(InputSplit split) {
        return new Shard(split.start(), split.end(), 0L);
    }
}

