/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.log4j.Logger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RSProcedureHandler
extends EventHandler {
    private static final Logger LOG = Logger.getLogger(RSProcedureHandler.class);
    private final long procId;
    private final RSProcedureCallable callable;

    public RSProcedureHandler(HRegionServer rs, long procId, RSProcedureCallable callable) {
        super(rs, callable.getEventType());
        this.procId = procId;
        this.callable = callable;
    }

    @Override
    public void process() {
        Throwable error = null;
        try {
            this.callable.call();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error when call RSProcedureCallable: ", t);
            error = t;
        }
        finally {
            ((HRegionServer)this.server).remoteProcedureComplete(this.procId, error);
        }
    }
}

