/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerPreambleHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final NettyRpcServer rpcServer;

    public NettyRpcServerPreambleHandler(NettyRpcServer rpcServer) {
        this.rpcServer = rpcServer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        NettyServerRpcConnection conn = this.createNettyServerRpcConnection(ctx.channel());
        ByteBuffer buf = ByteBuffer.allocate(msg.readableBytes());
        msg.readBytes(buf);
        buf.flip();
        if (!conn.processPreamble(buf)) {
            conn.close();
            return;
        }
        ChannelPipeline p = ctx.pipeline();
        ((NettyRpcFrameDecoder)p.get("frameDecoder")).setConnection(conn);
        ((NettyRpcServerRequestDecoder)p.get("decoder")).setConnection(conn);
        p.remove((ChannelHandler)this);
        p.remove("preambleDecoder");
    }

    @VisibleForTesting
    protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
        return new NettyServerRpcConnection(this.rpcServer, channel);
    }
}

