/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.sofa;

import com.alipay.sofa.registry.client.api.ConfigDataObserver;
import com.alipay.sofa.registry.client.api.SubscriberDataObserver;
import com.alipay.sofa.registry.client.api.model.ConfigData;
import com.alipay.sofa.registry.client.api.model.UserData;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.sofa.ComposeUserData;
import com.alipay.sofa.rpc.registry.sofa.SofaRegistryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class SofaRegistrySubscribeCallback
implements SubscriberDataObserver,
ConfigDataObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SofaRegistrySubscribeCallback.class);
    public static final String CONFIG_SEPARATOR = "#";
    public static final String DEFAULT_ZONE = "DEFAULT_ZONE";
    ConcurrentHashMap<ConsumerConfig, ProviderInfoListener> providerInfoListeners = new ConcurrentHashMap();
    private UserData lastUserData;
    private ConfigData lastConfigData;
    AtomicBoolean[] flag = new AtomicBoolean[]{new AtomicBoolean(), new AtomicBoolean()};

    public void handleData(String dataId, UserData userData) {
        if (dataId == null) {
            return;
        }
        this.lastUserData = userData;
        this.printUserData(dataId, userData);
        if (this.flag != null) {
            this.flag[0].compareAndSet(false, true);
        }
        if (this.canNotify()) {
            this.flag = null;
            this.composeAndNotify(userData, this.lastConfigData);
        }
    }

    private boolean canNotify() {
        return this.flag == null || this.flag[0].get();
    }

    void handleDataToListener(String dataId, ConsumerConfig config, ProviderInfoListener listener) {
        if (!this.canNotify()) {
            return;
        }
        if (this.lastUserData != null) {
            ComposeUserData composeUserData = this.composeUserAndConfigData(this.lastUserData, this.lastConfigData);
            this.notifyToListener(listener, composeUserData);
        }
    }

    protected List<String> flatUserData(UserData userData) {
        ArrayList<String> result = new ArrayList<String>();
        Map zoneData = userData.getZoneData();
        for (Map.Entry entry : zoneData.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected List<ProviderInfo> flatComposeData(ComposeUserData userData) {
        ArrayList<ProviderInfo> result = new ArrayList<ProviderInfo>();
        Map<String, List<ProviderInfo>> zoneData = userData.getZoneData();
        for (Map.Entry<String, List<ProviderInfo>> entry : zoneData.entrySet()) {
            result.addAll((Collection<ProviderInfo>)entry.getValue());
        }
        return result;
    }

    private ComposeUserData composeUserAndConfigData(UserData userData, ConfigData configData) {
        ComposeUserData result = new ComposeUserData();
        HashMap<String, List<ProviderInfo>> zoneData = new HashMap<String, List<ProviderInfo>>();
        if (userData == null) {
            return result;
        }
        result.setLocalZone(userData.getLocalZone());
        Map listZoneData = userData.getZoneData();
        String[] configDatas = StringUtils.split(configData == null ? "" : configData.getData(), CONFIG_SEPARATOR);
        List<String> attrData = Arrays.asList(configDatas);
        for (String key : listZoneData.keySet()) {
            List<ProviderInfo> providerInfos = this.mergeProviderInfo((List)listZoneData.get(key), attrData);
            zoneData.put(key, providerInfos);
        }
        result.setZoneData(zoneData);
        return result;
    }

    List<ProviderInfo> mergeProviderInfo(List<String> userDatas, List<String> configDatas) {
        List<ProviderInfo> providers = SofaRegistryHelper.parseProviderInfos(userDatas);
        if (CommonUtils.isNotEmpty(providers) && CommonUtils.isNotEmpty(configDatas)) {
            List<ProviderInfo> override = SofaRegistryHelper.parseProviderInfos(configDatas);
            Iterator<ProviderInfo> iterator = providers.iterator();
            while (iterator.hasNext()) {
                ProviderInfo origin = iterator.next();
                for (ProviderInfo over : override) {
                    if (!"override".equals(over.getProtocolType()) || !StringUtils.equals(origin.getHost(), over.getHost()) || origin.getPort() != over.getPort()) continue;
                    if (over.getWeight() != origin.getWeight()) {
                        origin.setWeight(over.getWeight());
                    }
                    if (!CommonUtils.isTrue(over.getAttr("disabled"))) continue;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Provider is disabled by override. {}", origin.toUrl());
                    }
                    iterator.remove();
                }
            }
        }
        return providers;
    }

    void addProviderInfoListener(String dataId, ConsumerConfig consumerConfig, ProviderInfoListener listener) {
        this.providerInfoListeners.put(consumerConfig, listener);
        if (LOGGER.isWarnEnabled(consumerConfig.getAppName()) && this.providerInfoListeners.size() > 5) {
            LOGGER.warnWithApp(consumerConfig.getAppName(), "Duplicate to add provider listener of {} more than 5 times, now is {}, please check it", dataId, this.providerInfoListeners.size());
        }
    }

    void remove(String dataId, ConsumerConfig consumerConfig) {
        this.providerInfoListeners.remove(consumerConfig);
    }

    public int getListenerNum() {
        return this.providerInfoListeners.size();
    }

    private void printUserData(String dataId, UserData userData) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        if (userData != null && userData.getZoneData() != null) {
            Map oneUserData = userData.getZoneData();
            for (Map.Entry entry : oneUserData.entrySet()) {
                sb.append("  --- ").append((String)entry.getKey()).append("\n");
                for (String provider : (List)entry.getValue()) {
                    sb.append("   >>> ").append(provider).append("\n");
                    ++count;
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(LogCodes.getLog("010060001", dataId, count, sb.toString()));
        }
    }

    private void printConfigData(String dataId, ConfigData configData) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        if (configData != null && StringUtils.isNotBlank(configData.getData())) {
            String[] split = StringUtils.split(configData.getData(), CONFIG_SEPARATOR);
            List<String> dataList = Arrays.asList(split);
            for (String provider : dataList) {
                sb.append("  >>> ").append(provider).append("\n");
                ++count;
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(LogCodes.getLiteLog("Receive RPC config info: service[{0}]\n  usable config info[{1}]\n{2}", dataId, count, sb.toString()));
        }
    }

    public void handleData(String dataId, ConfigData configData) {
        if (dataId == null) {
            return;
        }
        this.lastConfigData = configData;
        this.printConfigData(dataId, configData);
        if (this.flag != null) {
            this.flag[1].compareAndSet(false, true);
        }
        if (this.canNotify()) {
            this.flag = null;
            this.composeAndNotify(this.lastUserData, configData);
        }
    }

    private void composeAndNotify(UserData userData, ConfigData configData) {
        ComposeUserData mergedResult = this.composeUserAndConfigData(userData, configData);
        this.notifyToListener(mergedResult);
    }

    private void notifyToListener(ComposeUserData mergedResult) {
        for (Map.Entry<ConsumerConfig, ProviderInfoListener> entry : this.providerInfoListeners.entrySet()) {
            this.notifyToListener(entry.getValue(), mergedResult);
        }
    }

    private void notifyToListener(ProviderInfoListener listener, ComposeUserData mergedResult) {
        if ("".equalsIgnoreCase(mergedResult.getLocalZone()) || DEFAULT_ZONE.equalsIgnoreCase(mergedResult.getLocalZone())) {
            listener.updateProviders(new ProviderGroup(this.flatComposeData(mergedResult)));
        } else {
            Map<String, List<ProviderInfo>> zoneData = mergedResult.getZoneData();
            ArrayList<ProviderGroup> result = new ArrayList<ProviderGroup>();
            for (Map.Entry<String, List<ProviderInfo>> dataEntry : zoneData.entrySet()) {
                if (dataEntry.getKey().equalsIgnoreCase(mergedResult.getLocalZone())) {
                    result.add(new ProviderGroup(dataEntry.getValue()));
                }
                result.add(new ProviderGroup(dataEntry.getKey(), dataEntry.getValue()));
            }
            listener.updateAllProviders(result);
        }
    }
}

