/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.proxy;

import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.ext.ExtensionClass;
import com.alipay.sofa.rpc.ext.ExtensionLoaderFactory;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.proxy.Proxy;

public final class ProxyFactory {
    public static <T> T buildProxy(String proxyType, Class<T> clazz, Invoker proxyInvoker) throws Exception {
        try {
            ExtensionClass<Proxy> ext = ExtensionLoaderFactory.getExtensionLoader(Proxy.class).getExtensionClass(proxyType);
            if (ext == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "Proxy", proxyType));
            }
            Proxy proxy = ext.getExtInstance();
            return proxy.getProxy(clazz, proxyInvoker);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "Proxy", proxyType), e);
        }
    }

    public static Invoker getInvoker(Object proxyObject, String proxyType) {
        try {
            ExtensionClass<Proxy> ext = ExtensionLoaderFactory.getExtensionLoader(Proxy.class).getExtensionClass(proxyType);
            if (ext == null) {
                throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "Registry", proxyType));
            }
            Proxy proxy = ext.getExtInstance();
            return proxy.getInvoker(proxyObject);
        }
        catch (SofaRpcRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010030007", "Registry", proxyType));
        }
    }
}

