/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.client.lb;

import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.client.AbstractLoadBalancer;
import com.alipay.sofa.rpc.client.LoadBalancer;
import com.alipay.sofa.rpc.client.LoadBalancerFactory;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.dynamic.DynamicConfigManager;
import com.alipay.sofa.rpc.dynamic.DynamicConfigManagerFactory;
import com.alipay.sofa.rpc.dynamic.DynamicHelper;
import com.alipay.sofa.rpc.ext.Extension;
import java.util.List;

@Extension(value="auto")
public class AutoLoadBalancer
extends AbstractLoadBalancer {
    protected static final String LOAD_BALANCER_KEY = "loadBalancer";
    protected static final String DEFAULT_LOAD_BALANCER = "random";

    public AutoLoadBalancer(ConsumerBootstrap consumerBootstrap) {
        super(consumerBootstrap);
    }

    @Override
    protected ProviderInfo doSelect(SofaRequest request, List<ProviderInfo> providerInfos) {
        String dynamicAlias = this.consumerConfig.getParameter("dynamicAlias");
        if (StringUtils.isNotBlank(dynamicAlias)) {
            String dynamicLoadBalancer = null;
            DynamicConfigManager dynamicConfigManager = DynamicConfigManagerFactory.getDynamicManager(this.consumerConfig.getAppName(), dynamicAlias);
            if (dynamicConfigManager != null && DynamicHelper.isNotDefault(dynamicLoadBalancer = dynamicConfigManager.getConsumerServiceProperty(request.getTargetServiceUniqueName(), LOAD_BALANCER_KEY)) && StringUtils.isNotBlank(dynamicLoadBalancer)) {
                LoadBalancer loadBalancer = LoadBalancerFactory.getLoadBalancer(this.consumerBootstrap, dynamicLoadBalancer);
                return loadBalancer.select(request, providerInfos);
            }
        }
        LoadBalancer loadBalancer = LoadBalancerFactory.getLoadBalancer(this.consumerBootstrap, DEFAULT_LOAD_BALANCER);
        return loadBalancer.select(request, providerInfos);
    }
}

