/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.line;

import java.io.IOException;
import java.util.List;
import org.apache.hugegraph.loader.reader.Readable;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.util.E;

public abstract class LineFetcher {
    private final InputSource source;
    private long offset;

    public LineFetcher(InputSource source) {
        E.checkNotNull((Object)source, (String)"source");
        this.source = source;
        this.offset = 0L;
    }

    public InputSource source() {
        return this.source;
    }

    public long offset() {
        return this.offset;
    }

    protected void resetOffset() {
        this.offset = 0L;
    }

    protected void addOffset(long offset) {
        this.offset += offset;
    }

    protected void increaseOffset() {
        ++this.offset;
    }

    public abstract boolean ready();

    public abstract void resetReader();

    public abstract boolean needReadHeader();

    public abstract String[] readHeader(List<Readable> var1);

    public abstract void openReader(Readable var1);

    public abstract void closeReader() throws IOException;

    public abstract Line fetch() throws IOException;
}

