/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.reader.line;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hugegraph.util.E;

public final class Line {
    private String rawLine;
    private String[] names;
    private Object[] values;

    public Line(String rawLine, String[] names, Object[] values) {
        E.checkArgumentNotNull((Object)rawLine, (String)"The rawLine can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)names, (String)"The names can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)values, (String)"The values can't be null", (Object[])new Object[0]);
        if (names.length != values.length) {
            E.checkArgument((names.length == values.length ? 1 : 0) != 0, (String)"The length of names %s should be same as values %s", (Object[])new Object[]{Arrays.toString(names), Arrays.toString(values)});
        }
        this.rawLine = rawLine;
        this.names = names;
        this.values = values;
    }

    public String rawLine() {
        return this.rawLine;
    }

    public void rawLine(String rawLine) {
        this.rawLine = rawLine;
    }

    public final String[] names() {
        return this.names;
    }

    public void names(String[] names) {
        this.names = names;
    }

    public final Object[] values() {
        return this.values;
    }

    public void values(Object[] values) {
        this.values = values;
    }

    public void retainAll(String[] names) {
        HashSet set = Sets.newHashSet((Object[])names);
        ArrayList<String> retainedNames = new ArrayList<String>();
        ArrayList<Object> retainedValues = new ArrayList<Object>();
        for (int i = 0; i < this.names.length; ++i) {
            if (!set.contains(this.names[i])) continue;
            retainedNames.add(this.names[i]);
            retainedValues.add(this.values[i]);
        }
        this.names = retainedNames.toArray(new String[0]);
        this.values = retainedValues.toArray(new Object[0]);
    }

    public String toString() {
        return this.rawLine;
    }
}

