/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.builder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.structure.schema.PropertyKey;
import org.apache.hugegraph.structure.schema.VertexLabel;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class SchemaCache {
    private final HugeClient client;
    private final Map<String, PropertyKey> propertyKeys;
    private final Map<String, VertexLabel> vertexLabels;
    private final Map<String, EdgeLabel> edgeLabels;

    public SchemaCache(HugeClient client) {
        this.client = client;
        this.propertyKeys = new HashMap<String, PropertyKey>();
        this.vertexLabels = new HashMap<String, VertexLabel>();
        this.edgeLabels = new HashMap<String, EdgeLabel>();
    }

    @JsonCreator
    public SchemaCache(@JsonProperty(value="propertykeys") List<PropertyKey> propertyKeyList, @JsonProperty(value="vertexlabels") List<VertexLabel> vertexLabelList, @JsonProperty(value="edgelabels") List<EdgeLabel> edgeLabelList) {
        this.client = null;
        this.propertyKeys = new HashMap<String, PropertyKey>();
        this.vertexLabels = new HashMap<String, VertexLabel>();
        this.edgeLabels = new HashMap<String, EdgeLabel>();
        propertyKeyList.forEach(pk -> this.propertyKeys.put(pk.name(), (PropertyKey)pk));
        vertexLabelList.forEach(vl -> this.vertexLabels.put(vl.name(), (VertexLabel)vl));
        edgeLabelList.forEach(el -> this.edgeLabels.put(el.name(), (EdgeLabel)el));
    }

    public void updateAll() {
        this.propertyKeys.clear();
        this.client.schema().getPropertyKeys().forEach(pk -> this.propertyKeys.put(pk.name(), (PropertyKey)pk));
        this.vertexLabels.clear();
        this.client.schema().getVertexLabels().forEach(vl -> this.vertexLabels.put(vl.name(), (VertexLabel)vl));
        this.edgeLabels.clear();
        this.client.schema().getEdgeLabels().forEach(el -> this.edgeLabels.put(el.name(), (EdgeLabel)el));
    }

    public PropertyKey getPropertyKey(String name) {
        PropertyKey propertyKey = this.propertyKeys.get(name);
        if (propertyKey == null) {
            try {
                propertyKey = this.client.schema().getPropertyKey(name);
            }
            catch (ServerException e) {
                throw new LoadException("The property key '%s' doesn't exist", name);
            }
        }
        return propertyKey;
    }

    public VertexLabel getVertexLabel(String name) {
        VertexLabel vertexLabel = this.vertexLabels.get(name);
        if (vertexLabel == null) {
            try {
                vertexLabel = this.client.schema().getVertexLabel(name);
            }
            catch (ServerException e) {
                throw new LoadException("The vertex label '%s' doesn't exist", name);
            }
        }
        return vertexLabel;
    }

    public EdgeLabel getEdgeLabel(String name) {
        EdgeLabel edgeLabel = this.edgeLabels.get(name);
        if (edgeLabel == null) {
            try {
                edgeLabel = this.client.schema().getEdgeLabel(name);
            }
            catch (ServerException e) {
                throw new LoadException("The edge label '%s' doesn't exist", name);
            }
        }
        return edgeLabel;
    }

    public boolean isEmpty() {
        return this.propertyKeys.isEmpty() && this.vertexLabels.isEmpty() && this.edgeLabels.isEmpty();
    }
}

