/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.registry;

import com.alipay.common.tracer.core.appender.self.SelfLog;
import com.alipay.common.tracer.core.constants.SofaTracerConstant;
import com.alipay.common.tracer.core.context.span.SofaTracerSpanContext;
import com.alipay.common.tracer.core.registry.RegistryExtractorInjector;
import com.alipay.common.tracer.core.utils.ByteArrayUtils;
import io.opentracing.propagation.Format;
import java.nio.ByteBuffer;

public class BinaryFormater
implements RegistryExtractorInjector<ByteBuffer> {
    private static final byte[] FORMATER_KEY_HEAD_BYTES = "sftc_head".getBytes(SofaTracerConstant.DEFAULT_UTF8_CHARSET);

    @Override
    public Format<ByteBuffer> getFormatType() {
        return Format.Builtin.BINARY;
    }

    @Override
    public SofaTracerSpanContext extract(ByteBuffer carrier) {
        byte[] formaterKeyHeadBytes;
        if (carrier == null || carrier.array().length < FORMATER_KEY_HEAD_BYTES.length) {
            return SofaTracerSpanContext.rootStart();
        }
        byte[] carrierDatas = carrier.array();
        int index = ByteArrayUtils.indexOf(carrierDatas, formaterKeyHeadBytes = FORMATER_KEY_HEAD_BYTES);
        if (index < 0) {
            return SofaTracerSpanContext.rootStart();
        }
        try {
            carrier.position(index + formaterKeyHeadBytes.length);
            byte[] contextDataBytes = new byte[carrier.getInt()];
            carrier.get(contextDataBytes);
            String spanContextInfos = new String(contextDataBytes, SofaTracerConstant.DEFAULT_UTF8_CHARSET);
            return SofaTracerSpanContext.deserializeFromString(spanContextInfos);
        }
        catch (Exception e) {
            SelfLog.error("com.alipay.common.tracer.core.registry.BinaryFormater.extract Error.Recover by root start", e);
            return SofaTracerSpanContext.rootStart();
        }
    }

    @Override
    public void inject(SofaTracerSpanContext spanContext, ByteBuffer carrier) {
        if (carrier == null || spanContext == null) {
            return;
        }
        carrier.put(FORMATER_KEY_HEAD_BYTES);
        String spanContextInfos = spanContext.serializeSpanContext();
        byte[] value = spanContextInfos.getBytes(SofaTracerConstant.DEFAULT_UTF8_CHARSET);
        carrier.putInt(value.length);
        carrier.put(value);
    }
}

