/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.util;

import org.simpleflatmapper.util.AndPredicate;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.Predicate;

public class PredicatedEnumerable<T>
implements Enumerable<T> {
    private final Enumerable<? extends T> delegate;
    private final Predicate<? super T> predicate;

    public PredicatedEnumerable(Enumerable<? extends T> delegate, Predicate<? super T> predicate) {
        if (delegate instanceof PredicatedEnumerable) {
            PredicatedEnumerable pe = (PredicatedEnumerable)delegate;
            this.delegate = pe.delegate;
            this.predicate = new AndPredicate<T>(pe.predicate, predicate);
        } else {
            this.delegate = delegate;
            this.predicate = predicate;
        }
    }

    @Override
    public boolean next() {
        while (this.delegate.next()) {
            if (!this.predicate.test(this.delegate.currentValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public T currentValue() {
        return this.delegate.currentValue();
    }
}

