/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.internal;

import io.vavr.control.Either;
import java.time.Duration;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class HandlerRegistration
implements Future<Void> {
    private static int counter = 0;
    private final int id = counter++;
    private final String name;
    private final Deque<Either<Function<?, ?>, Predicate<?>>> commands;
    private final Class<?> expectClazz;
    private final Consumer<?> packetConsumer;
    private final Consumer<TimeoutException> onTimeoutConsumer;
    private final BiConsumer<?, ? extends Throwable> errorConsumer;
    private final Runnable onHandled;
    private final Runnable onError;
    private final Runnable onCancelled;
    private final Duration timeout;
    private final CompletableFuture<Void> handled = new CompletableFuture();

    public HandlerRegistration(String name, Deque<Either<Function<?, ?>, Predicate<?>>> commands, Class<?> expectClazz, Consumer<?> packetConsumer, Consumer<TimeoutException> onTimeoutConsumer, BiConsumer<?, ? extends Throwable> errorConsumer, Duration timeout) {
        this(name, commands, expectClazz, packetConsumer, onTimeoutConsumer, errorConsumer, () -> {}, () -> {}, () -> {}, timeout);
    }

    public HandlerRegistration(String name, Deque<Either<Function<?, ?>, Predicate<?>>> commands, Class<?> expectClazz, Consumer<?> packetConsumer, Consumer<TimeoutException> onTimeoutConsumer, BiConsumer<?, ? extends Throwable> errorConsumer, Runnable onHandled, Runnable onError, Runnable onCancelled, Duration timeout) {
        this.name = name;
        this.commands = commands;
        this.expectClazz = expectClazz;
        this.packetConsumer = packetConsumer;
        this.onTimeoutConsumer = onTimeoutConsumer;
        this.errorConsumer = errorConsumer;
        this.onHandled = onHandled;
        this.onError = onError;
        this.onCancelled = onCancelled;
        this.timeout = timeout;
    }

    public String getName() {
        return this.name;
    }

    public Deque<Either<Function<?, ?>, Predicate<?>>> getCommands() {
        return this.commands;
    }

    public Class<?> getExpectClazz() {
        return this.expectClazz;
    }

    public Consumer<?> getPacketConsumer() {
        return this.packetConsumer;
    }

    public Consumer<TimeoutException> getOnTimeoutConsumer() {
        return this.onTimeoutConsumer;
    }

    public BiConsumer<?, ? extends Throwable> getErrorConsumer() {
        return this.errorConsumer;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void cancel() {
        this.handled.cancel(true);
        this.onCancelled.run();
    }

    @Override
    public boolean cancel(boolean ignored) {
        if (this.isCancelled()) {
            return false;
        }
        this.cancel();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.handled.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.hasHandled();
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        return this.handled.get();
    }

    @Override
    public Void get(long amount, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.handled.get(amount, timeUnit);
    }

    public void confirmHandled() {
        this.confirmCompleted();
        this.onHandled.run();
    }

    public void confirmError() {
        this.confirmCompleted();
        this.onError.run();
    }

    public void confirmCompleted() {
        this.handled.complete(null);
    }

    public boolean hasHandled() {
        return this.handled.isDone();
    }

    public String toString() {
        return "HandlerRegistration#" + this.id;
    }
}

