/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.arrow;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.arrow.vector.table.Row;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.hertzbeat.common.entity.arrow.ArrowCell;

public class RowWrapper {
    private final Row currentRow;
    private final Iterator<Row> rowIterator;
    private final List<Field> fieldList;
    private int rowIndex;
    private int fieldIndex;

    public RowWrapper(Row row, Iterator<Row> rowIterator, List<Field> fieldList, int rowIndex) {
        this.currentRow = row;
        this.rowIterator = rowIterator;
        this.fieldList = fieldList;
        this.fieldIndex = 0;
        this.rowIndex = rowIndex;
    }

    public boolean hasNextRow() {
        return this.rowIterator.hasNext();
    }

    public RowWrapper nextRow() {
        return new RowWrapper(this.rowIterator.next(), this.rowIterator, this.fieldList, ++this.rowIndex);
    }

    public ArrowCell nextCell() {
        if (!this.hasNextCell() || this.currentRow == null) {
            throw new NoSuchElementException("No more cells in current row");
        }
        return new ArrowCell(this.fieldList.get(this.fieldIndex++), this.currentRow);
    }

    public Stream<ArrowCell> cellStream() {
        return this.fieldList.stream().map(field -> new ArrowCell((Field)field, this.currentRow));
    }

    public boolean hasNextCell() {
        return this.fieldIndex < this.fieldList.size();
    }

    public void resetCellIndex() {
        this.fieldIndex = 0;
    }

    public List<Field> getFieldList() {
        return this.fieldList;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }
}

