/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sshd.agent.common.AgentForwardSupport;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionHolder;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.future.GlobalRequestFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.helpers.AbstractConnectionService;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.x11.X11ForwardSupport;

public class ClientConnectionService
extends AbstractConnectionService
implements ClientSessionHolder {
    protected final String heartbeatRequest;
    protected final Duration heartbeatInterval;
    protected final int heartbeatMaxNoReply;
    protected final AtomicInteger outstandingHeartbeats = new AtomicInteger();
    protected ScheduledFuture<?> clientHeartbeat;

    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
        this.heartbeatRequest = (String)CoreModuleProperties.HEARTBEAT_REQUEST.getRequired((PropertyResolver)this);
        this.heartbeatInterval = (Duration)CoreModuleProperties.HEARTBEAT_INTERVAL.getRequired((PropertyResolver)this);
        this.heartbeatMaxNoReply = this.configureMaxNoReply();
    }

    protected int configureMaxNoReply() {
        Duration timeout = (Duration)CoreModuleProperties.HEARTBEAT_REPLY_WAIT.getOrNull((PropertyResolver)this);
        if (timeout == null || GenericUtils.isNegativeOrNull((Duration)this.heartbeatInterval) || GenericUtils.isEmpty((CharSequence)this.heartbeatRequest)) {
            return (Integer)CoreModuleProperties.HEARTBEAT_NO_REPLY_MAX.getRequired((PropertyResolver)this);
        }
        Integer noReplyValue = (Integer)CoreModuleProperties.HEARTBEAT_NO_REPLY_MAX.getOrNull((PropertyResolver)this);
        if (noReplyValue != null) {
            return noReplyValue;
        }
        if (GenericUtils.isNegativeOrNull((Duration)timeout)) {
            return 0;
        }
        if (timeout.compareTo(this.heartbeatInterval) >= 0) {
            double intervalSec;
            double timeoutSec = (double)timeout.getSeconds() + (double)timeout.getNano() / 1.0E9;
            double multiple = timeoutSec / (intervalSec = (double)this.heartbeatInterval.getSeconds() + (double)this.heartbeatInterval.getNano() / 1.0E9);
            if (multiple >= 2.147483646E9) {
                return Integer.MAX_VALUE;
            }
            return (int)multiple + 1;
        }
        return 1;
    }

    @Override
    public final ClientSession getClientSession() {
        return this.getSession();
    }

    @Override
    public AbstractClientSession getSession() {
        return (AbstractClientSession)super.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        super.start();
    }

    @Override
    protected synchronized ScheduledFuture<?> startHeartBeat() {
        if (!GenericUtils.isNegativeOrNull((Duration)this.heartbeatInterval) && GenericUtils.isNotEmpty((CharSequence)this.heartbeatRequest)) {
            this.stopHeartBeat();
            this.outstandingHeartbeats.set(0);
            ClientSession session = this.getClientSession();
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            this.clientHeartbeat = service.scheduleAtFixedRate(this::sendHeartBeat, this.heartbeatInterval.toMillis(), this.heartbeatInterval.toMillis(), TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat({}) - started at interval={} with request={}", new Object[]{session, this.heartbeatInterval, this.heartbeatRequest});
            }
            return this.clientHeartbeat;
        }
        return super.startHeartBeat();
    }

    @Override
    protected synchronized void stopHeartBeat() {
        try {
            super.stopHeartBeat();
        }
        finally {
            if (this.clientHeartbeat != null) {
                this.clientHeartbeat = null;
            }
        }
    }

    @Override
    protected boolean sendHeartBeat() {
        if (this.clientHeartbeat == null) {
            return super.sendHeartBeat();
        }
        AbstractClientSession session = this.getSession();
        if (session.getKexState() != KexState.DONE) {
            return false;
        }
        try {
            this.heartbeatCount.incrementAndGet();
            boolean withReply = this.heartbeatMaxNoReply > 0;
            int outstanding = this.outstandingHeartbeats.incrementAndGet();
            if (withReply && this.heartbeatMaxNoReply < outstanding) {
                throw new SshException("Got " + (outstanding - 1) + " heartbeat requests without reply");
            }
            Buffer buf = session.createBuffer((byte)80, this.heartbeatRequest.length() + 8);
            buf.putString(this.heartbeatRequest);
            buf.putBoolean(withReply);
            if (withReply) {
                GlobalRequestFuture future = session.request(buf, this.heartbeatRequest, (cmd, buffer) -> this.outstandingHeartbeats.set(0));
                future.addListener(this::futureDone);
            } else {
                IoWriteFuture future = session.writePacket(buf);
                future.addListener(this::futureDone);
            }
            return true;
        }
        catch (IOException | Error | RuntimeException e) {
            session.exceptionCaught(e);
            this.warn("sendHeartBeat({}) failed ({}) to send heartbeat #{} request={}: {}", session, e.getClass().getSimpleName(), this.heartbeatCount, this.heartbeatRequest, e.getMessage(), e);
            return false;
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

