/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.HttpClientProperties;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AssumeRoleAwsClientFactory
implements AwsClientFactory {
    private AwsProperties awsProperties;
    private HttpClientProperties httpClientProperties;
    private S3FileIOProperties s3FileIOProperties;
    private String roleSessionName;

    @Override
    public S3Client s3() {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyServiceConfigurations)).applyMutation(this.s3FileIOProperties::applySignerConfiguration)).build();
    }

    @Override
    public GlueClient glue() {
        return (GlueClient)((GlueClientBuilder)((GlueClientBuilder)GlueClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).build();
    }

    @Override
    public KmsClient kms() {
        return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).build();
    }

    @Override
    public DynamoDbClient dynamo() {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().applyMutation(this::applyAssumeRoleConfigurations)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsProperties::applyDynamoDbEndpointConfigurations)).build();
    }

    @Override
    public void initialize(Map<String, String> properties) {
        this.awsProperties = new AwsProperties(properties);
        this.s3FileIOProperties = new S3FileIOProperties(properties);
        this.httpClientProperties = new HttpClientProperties(properties);
        this.roleSessionName = this.genSessionName();
        Preconditions.checkNotNull((Object)this.awsProperties.clientAssumeRoleArn(), (Object)"Cannot initialize AssumeRoleClientConfigFactory with null role ARN");
        Preconditions.checkNotNull((Object)this.awsProperties.clientAssumeRoleRegion(), (Object)"Cannot initialize AssumeRoleClientConfigFactory with null region");
    }

    protected <T extends AwsClientBuilder & AwsSyncClientBuilder> T applyAssumeRoleConfigurations(T clientBuilder) {
        AssumeRoleRequest assumeRoleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(this.awsProperties.clientAssumeRoleArn()).roleSessionName(this.roleSessionName).durationSeconds(Integer.valueOf(this.awsProperties.clientAssumeRoleTimeoutSec())).externalId(this.awsProperties.clientAssumeRoleExternalId()).tags(this.awsProperties.stsClientAssumeRoleTags()).build();
        clientBuilder.credentialsProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(this.sts())).refreshRequest(assumeRoleRequest).build()).region(Region.of((String)this.awsProperties.clientAssumeRoleRegion()));
        return clientBuilder;
    }

    protected String region() {
        return this.awsProperties.clientAssumeRoleRegion();
    }

    protected AwsProperties awsProperties() {
        return this.awsProperties;
    }

    protected HttpClientProperties httpClientProperties() {
        return this.httpClientProperties;
    }

    protected S3FileIOProperties s3FileIOProperties() {
        return this.s3FileIOProperties;
    }

    private StsClient sts() {
        return (StsClient)((StsClientBuilder)StsClient.builder().applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).build();
    }

    private String genSessionName() {
        if (this.awsProperties.clientAssumeRoleSessionName() != null) {
            return this.awsProperties.clientAssumeRoleSessionName();
        }
        return String.format("iceberg-aws-%s", UUID.randomUUID());
    }
}

