/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.catalog.TableDispatcher;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NoSuchTableException;
import org.apache.gravitino.exceptions.TableAlreadyExistsException;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterTableEvent;
import org.apache.gravitino.listener.api.event.AlterTableFailureEvent;
import org.apache.gravitino.listener.api.event.CreateTableEvent;
import org.apache.gravitino.listener.api.event.CreateTableFailureEvent;
import org.apache.gravitino.listener.api.event.DropTableEvent;
import org.apache.gravitino.listener.api.event.DropTableFailureEvent;
import org.apache.gravitino.listener.api.event.ListTableEvent;
import org.apache.gravitino.listener.api.event.ListTableFailureEvent;
import org.apache.gravitino.listener.api.event.LoadTableEvent;
import org.apache.gravitino.listener.api.event.LoadTableFailureEvent;
import org.apache.gravitino.listener.api.event.PurgeTableEvent;
import org.apache.gravitino.listener.api.event.PurgeTableFailureEvent;
import org.apache.gravitino.listener.api.info.TableInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.TableChange;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.utils.PrincipalUtils;

public class TableEventDispatcher
implements TableDispatcher {
    private final EventBus eventBus;
    private final TableDispatcher dispatcher;

    public TableEventDispatcher(EventBus eventBus, TableDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listTables(Namespace namespace) throws NoSuchSchemaException {
        try {
            NameIdentifier[] nameIdentifiers = this.dispatcher.listTables(namespace);
            this.eventBus.dispatchEvent(new ListTableEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return nameIdentifiers;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListTableFailureEvent(PrincipalUtils.getCurrentUserName(), namespace, e));
            throw e;
        }
    }

    public Table loadTable(NameIdentifier ident) throws NoSuchTableException {
        try {
            Table table = this.dispatcher.loadTable(ident);
            this.eventBus.dispatchEvent(new LoadTableEvent(PrincipalUtils.getCurrentUserName(), ident, new TableInfo(table)));
            return table;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadTableFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public Table createTable(NameIdentifier ident, Column[] columns, String comment, Map<String, String> properties, Transform[] partitions, Distribution distribution, SortOrder[] sortOrders, Index[] indexes) throws NoSuchSchemaException, TableAlreadyExistsException {
        try {
            Table table = this.dispatcher.createTable(ident, columns, comment, properties, partitions, distribution, sortOrders, indexes);
            this.eventBus.dispatchEvent(new CreateTableEvent(PrincipalUtils.getCurrentUserName(), ident, new TableInfo(table)));
            return table;
        }
        catch (Exception e) {
            TableInfo createTableRequest = new TableInfo(ident.name(), columns, comment, properties, partitions, distribution, sortOrders, indexes, null);
            this.eventBus.dispatchEvent(new CreateTableFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, createTableRequest));
            throw e;
        }
    }

    public Table alterTable(NameIdentifier ident, TableChange ... changes) throws NoSuchTableException, IllegalArgumentException {
        try {
            Table table = this.dispatcher.alterTable(ident, changes);
            this.eventBus.dispatchEvent(new AlterTableEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new TableInfo(table)));
            return table;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterTableFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    public boolean dropTable(NameIdentifier ident) {
        try {
            boolean isExists = this.dispatcher.dropTable(ident);
            this.eventBus.dispatchEvent(new DropTableEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropTableFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public boolean purgeTable(NameIdentifier ident) {
        try {
            boolean isExists = this.dispatcher.purgeTable(ident);
            this.eventBus.dispatchEvent(new PurgeTableEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new PurgeTableFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public boolean tableExists(NameIdentifier ident) {
        return this.dispatcher.tableExists(ident);
    }
}

