/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.plugin;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.plugin.Bundle;
import org.datanucleus.plugin.Extension;
import org.datanucleus.plugin.ExtensionPoint;
import org.datanucleus.plugin.PluginParser;
import org.datanucleus.plugin.PluginRegistry;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class OSGiBundleParser {
    static DocumentBuilderFactory dbFactory = null;

    public static Bundle parseManifest(org.osgi.framework.Bundle osgiBundle) {
        Dictionary headers = osgiBundle.getHeaders();
        Bundle bundle = null;
        try {
            String symbolicName = OSGiBundleParser.getBundleSymbolicName(headers, null);
            String bundleVersion = OSGiBundleParser.getBundleVersion(headers, null);
            String bundleName = OSGiBundleParser.getBundleName(headers, null);
            String bundleVendor = OSGiBundleParser.getBundleVendor(headers, null);
            bundle = new Bundle(symbolicName, bundleName, bundleVendor, bundleVersion, null);
            bundle.setRequireBundle(OSGiBundleParser.getRequireBundle(headers));
        }
        catch (NucleusException ne) {
            NucleusLogger.GENERAL.warn("Plugin at bundle " + osgiBundle.getSymbolicName() + " (" + osgiBundle.getBundleId() + ") failed to parse so is being ignored", ne);
            return null;
        }
        return bundle;
    }

    private static List<Bundle.BundleDescription> getRequireBundle(Dictionary<String, String> headers) {
        String str = headers.get("Require-Bundle");
        if (str == null || str.length() < 1) {
            return Collections.emptyList();
        }
        PluginParser.Parser p = new PluginParser.Parser(str);
        ArrayList<Bundle.BundleDescription> requiredBundle = new ArrayList<Bundle.BundleDescription>();
        String bundleSymbolicName = p.parseSymbolicName();
        while (bundleSymbolicName != null) {
            Bundle.BundleDescription bd = new Bundle.BundleDescription();
            bd.setBundleSymbolicName(bundleSymbolicName);
            bd.setParameters(p.parseParameters());
            bundleSymbolicName = p.parseSymbolicName();
            requiredBundle.add(bd);
        }
        return requiredBundle;
    }

    private static List<ExtensionPoint> parseExtensionPoints(Element rootElement, Bundle plugin, org.osgi.framework.Bundle osgiBundle) {
        ArrayList<ExtensionPoint> extensionPoints = new ArrayList<ExtensionPoint>();
        NodeList elements = rootElement.getElementsByTagName("extension-point");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            String id = element.getAttribute("id").trim();
            String name = element.getAttribute("name");
            String schema = element.getAttribute("schema");
            extensionPoints.add(new ExtensionPoint(id, name, osgiBundle.getEntry(schema), plugin));
        }
        return extensionPoints;
    }

    private static List<Extension> parseExtensions(Element rootElement, Bundle plugin, org.osgi.framework.Bundle osgiBundle) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        NodeList elements = rootElement.getElementsByTagName("extension");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            Extension ex = new Extension(element.getAttribute("point"), plugin);
            NodeList elms = element.getChildNodes();
            extensions.add(ex);
            for (int e = 0; e < elms.getLength(); ++e) {
                if (!(elms.item(e) instanceof Element)) continue;
                ex.addConfigurationElement(PluginParser.parseConfigurationElement(ex, (Element)elms.item(e), null));
            }
        }
        return extensions;
    }

    private static String getHeaderValue(Dictionary<String, String> headers, String key, String defaultValue) {
        if (headers == null) {
            return defaultValue;
        }
        String name = headers.get(key);
        if (name == null) {
            return defaultValue;
        }
        return name;
    }

    private static String getBundleSymbolicName(Dictionary<String, String> headers, String defaultValue) {
        String name = OSGiBundleParser.getHeaderValue(headers, "Bundle-SymbolicName", defaultValue);
        StringTokenizer token = new StringTokenizer(name, ";");
        return token.nextToken().trim();
    }

    private static String getBundleName(Dictionary<String, String> headers, String defaultValue) {
        return OSGiBundleParser.getHeaderValue(headers, "Bundle-Name", defaultValue);
    }

    private static String getBundleVendor(Dictionary<String, String> headers, String defaultValue) {
        return OSGiBundleParser.getHeaderValue(headers, "Bundle-Vendor", defaultValue);
    }

    private static String getBundleVersion(Dictionary<String, String> headers, String defaultValue) {
        return OSGiBundleParser.getHeaderValue(headers, "Bundle-Version", defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List[] parsePluginElements(DocumentBuilder db, PluginRegistry mgr, URL fileUrl, Bundle plugin, org.osgi.framework.Bundle osgiBundle) {
        List<Object> extensionPoints = Collections.emptyList();
        List<Object> extensions = Collections.emptyList();
        InputStream is = null;
        try {
            is = fileUrl.openStream();
            Element rootElement = db.parse(new InputSource(new InputStreamReader(is))).getDocumentElement();
            if (NucleusLogger.GENERAL.isDebugEnabled()) {
                NucleusLogger.GENERAL.debug(Localiser.msg("024003", fileUrl.toString()));
            }
            extensionPoints = OSGiBundleParser.parseExtensionPoints(rootElement, plugin, osgiBundle);
            if (NucleusLogger.GENERAL.isDebugEnabled()) {
                NucleusLogger.GENERAL.debug(Localiser.msg("024004", fileUrl.toString()));
            }
            extensions = OSGiBundleParser.parseExtensions(rootElement, plugin, osgiBundle);
        }
        catch (NucleusException ex) {
            throw ex;
        }
        catch (Exception e) {
            NucleusLogger.GENERAL.error(Localiser.msg("024000", fileUrl.getFile()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return new List[]{extensionPoints, extensions};
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            if (dbFactory == null) {
                dbFactory = DocumentBuilderFactory.newInstance();
            }
            return dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new NucleusException(Localiser.msg("024016", e1.getMessage()));
        }
    }
}

