/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.payloads;

import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import org.apache.lucene.queries.payloads.PayloadMatcher;
import org.apache.lucene.queries.payloads.SpanPayloadCheckQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public class PayloadMatcherFactory {
    private static final EnumMap<SpanPayloadCheckQuery.PayloadType, EnumMap<SpanPayloadCheckQuery.MatchOperation, PayloadMatcher>> payloadCheckerOpTypeMap = new EnumMap(SpanPayloadCheckQuery.PayloadType.class);

    public static PayloadMatcher createMatcherForOpAndType(SpanPayloadCheckQuery.PayloadType payloadType, SpanPayloadCheckQuery.MatchOperation op) {
        if (op == null || SpanPayloadCheckQuery.MatchOperation.EQ.equals((Object)op)) {
            return new EQPayloadMatcher();
        }
        EnumMap<SpanPayloadCheckQuery.MatchOperation, PayloadMatcher> opMap = payloadCheckerOpTypeMap.get((Object)payloadType);
        if (opMap != null) {
            return opMap.get((Object)op);
        }
        return new EQPayloadMatcher();
    }

    static {
        EnumMap<SpanPayloadCheckQuery.MatchOperation, IntPayloadMatcher> intCheckers = new EnumMap<SpanPayloadCheckQuery.MatchOperation, IntPayloadMatcher>(SpanPayloadCheckQuery.MatchOperation.class);
        intCheckers.put(SpanPayloadCheckQuery.MatchOperation.LT, new LTIntPayloadMatcher());
        intCheckers.put(SpanPayloadCheckQuery.MatchOperation.LTE, new LTEIntPayloadMatcher());
        intCheckers.put(SpanPayloadCheckQuery.MatchOperation.GT, new GTIntPayloadMatcher());
        intCheckers.put(SpanPayloadCheckQuery.MatchOperation.GTE, new GTEIntPayloadMatcher());
        EnumMap<SpanPayloadCheckQuery.MatchOperation, FloatPayloadMatcher> floatCheckers = new EnumMap<SpanPayloadCheckQuery.MatchOperation, FloatPayloadMatcher>(SpanPayloadCheckQuery.MatchOperation.class);
        floatCheckers.put(SpanPayloadCheckQuery.MatchOperation.LT, new LTFloatPayloadMatcher());
        floatCheckers.put(SpanPayloadCheckQuery.MatchOperation.LTE, new LTEFloatPayloadMatcher());
        floatCheckers.put(SpanPayloadCheckQuery.MatchOperation.GT, new GTFloatPayloadMatcher());
        floatCheckers.put(SpanPayloadCheckQuery.MatchOperation.GTE, new GTEFloatPayloadMatcher());
        EnumMap<SpanPayloadCheckQuery.MatchOperation, StringPayloadMatcher> stringCheckers = new EnumMap<SpanPayloadCheckQuery.MatchOperation, StringPayloadMatcher>(SpanPayloadCheckQuery.MatchOperation.class);
        stringCheckers.put(SpanPayloadCheckQuery.MatchOperation.LT, new LTStringPayloadMatcher());
        stringCheckers.put(SpanPayloadCheckQuery.MatchOperation.LTE, new LTEStringPayloadMatcher());
        stringCheckers.put(SpanPayloadCheckQuery.MatchOperation.GT, new GTStringPayloadMatcher());
        stringCheckers.put(SpanPayloadCheckQuery.MatchOperation.GTE, new GTEStringPayloadMatcher());
        payloadCheckerOpTypeMap.put(SpanPayloadCheckQuery.PayloadType.INT, intCheckers);
        payloadCheckerOpTypeMap.put(SpanPayloadCheckQuery.PayloadType.FLOAT, floatCheckers);
        payloadCheckerOpTypeMap.put(SpanPayloadCheckQuery.PayloadType.STRING, stringCheckers);
    }

    private static class GTEFloatPayloadMatcher
    extends FloatPayloadMatcher {
        private GTEFloatPayloadMatcher() {
        }

        @Override
        protected boolean floatCompare(float val, float thresh) {
            return val >= thresh;
        }
    }

    private static class GTFloatPayloadMatcher
    extends FloatPayloadMatcher {
        private GTFloatPayloadMatcher() {
        }

        @Override
        protected boolean floatCompare(float val, float thresh) {
            return val > thresh;
        }
    }

    private static class LTEFloatPayloadMatcher
    extends FloatPayloadMatcher {
        private LTEFloatPayloadMatcher() {
        }

        @Override
        protected boolean floatCompare(float val, float thresh) {
            return val <= thresh;
        }
    }

    private static class LTFloatPayloadMatcher
    extends FloatPayloadMatcher {
        private LTFloatPayloadMatcher() {
        }

        @Override
        protected boolean floatCompare(float val, float thresh) {
            return val < thresh;
        }
    }

    private static abstract class FloatPayloadMatcher
    implements PayloadMatcher {
        private FloatPayloadMatcher() {
        }

        @Override
        public boolean comparePayload(BytesRef source, BytesRef payload) {
            return this.floatCompare(this.decodeFloat(payload.bytes, payload.offset), this.decodeFloat(source.bytes, source.offset));
        }

        private float decodeFloat(byte[] bytes, int offset) {
            return BitUtil.VH_BE_FLOAT.get(bytes, offset);
        }

        protected abstract boolean floatCompare(float var1, float var2);
    }

    private static class GTEIntPayloadMatcher
    extends IntPayloadMatcher {
        private GTEIntPayloadMatcher() {
        }

        @Override
        protected boolean intCompare(int val, int thresh) {
            return val >= thresh;
        }
    }

    private static class GTIntPayloadMatcher
    extends IntPayloadMatcher {
        private GTIntPayloadMatcher() {
        }

        @Override
        public boolean intCompare(int val, int thresh) {
            return val > thresh;
        }
    }

    private static class LTEIntPayloadMatcher
    extends IntPayloadMatcher {
        private LTEIntPayloadMatcher() {
        }

        @Override
        public boolean intCompare(int val, int thresh) {
            return val <= thresh;
        }
    }

    private static class LTIntPayloadMatcher
    extends IntPayloadMatcher {
        private LTIntPayloadMatcher() {
        }

        @Override
        public boolean intCompare(int val, int thresh) {
            return val < thresh;
        }
    }

    private static abstract class IntPayloadMatcher
    implements PayloadMatcher {
        private IntPayloadMatcher() {
        }

        @Override
        public boolean comparePayload(BytesRef source, BytesRef payload) {
            return this.intCompare(this.decodeInt(payload.bytes, payload.offset), this.decodeInt(source.bytes, source.offset));
        }

        private int decodeInt(byte[] bytes, int offset) {
            return BitUtil.VH_BE_INT.get(bytes, offset);
        }

        protected abstract boolean intCompare(int var1, int var2);
    }

    private static class GTEStringPayloadMatcher
    extends StringPayloadMatcher {
        private GTEStringPayloadMatcher() {
        }

        @Override
        protected boolean stringCompare(String val, String thresh) {
            int res = val.compareTo(thresh);
            return res > -1;
        }
    }

    private static class GTStringPayloadMatcher
    extends StringPayloadMatcher {
        private GTStringPayloadMatcher() {
        }

        @Override
        protected boolean stringCompare(String val, String thresh) {
            int res = val.compareTo(thresh);
            return res > 0;
        }
    }

    private static class LTEStringPayloadMatcher
    extends StringPayloadMatcher {
        private LTEStringPayloadMatcher() {
        }

        @Override
        protected boolean stringCompare(String val, String thresh) {
            int res = val.compareTo(thresh);
            return res < 1;
        }
    }

    private static class LTStringPayloadMatcher
    extends StringPayloadMatcher {
        private LTStringPayloadMatcher() {
        }

        @Override
        protected boolean stringCompare(String val, String thresh) {
            int res = val.compareTo(thresh);
            return res < 0;
        }
    }

    private static abstract class StringPayloadMatcher
    implements PayloadMatcher {
        private StringPayloadMatcher() {
        }

        @Override
        public boolean comparePayload(BytesRef source, BytesRef payload) {
            return this.stringCompare(this.decodeString(payload.bytes, payload.offset, payload.length), this.decodeString(source.bytes, source.offset, source.length));
        }

        private String decodeString(byte[] bytes, int offset, int length) {
            return new String(ArrayUtil.copyOfSubArray((byte[])bytes, (int)offset, (int)(offset + length)), StandardCharsets.UTF_8);
        }

        protected abstract boolean stringCompare(String var1, String var2);
    }

    private static class EQPayloadMatcher
    implements PayloadMatcher {
        private EQPayloadMatcher() {
        }

        @Override
        public boolean comparePayload(BytesRef source, BytesRef payload) {
            return source.bytesEquals(payload);
        }
    }
}

