/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.ProcessorSignalsConsumer;
import io.servicetalk.concurrent.api.SubscriberApiUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import javax.annotation.Nullable;

final class ProcessorBufferUtils {
    private ProcessorBufferUtils() {
    }

    static boolean consumeIfTerminal(ProcessorSignalsConsumer<?> consumer, @Nullable Object signal) {
        if (signal instanceof TerminalNotification) {
            Throwable cause = ((TerminalNotification)signal).cause();
            if (cause != null) {
                consumer.consumeTerminal(cause);
            } else {
                consumer.consumeTerminal();
            }
            return true;
        }
        return false;
    }

    static <T> boolean consumeNextItem(ProcessorSignalsConsumer<T> consumer, @Nullable Object nextItem) {
        if (nextItem == null) {
            return false;
        }
        consumer.consumeItem(SubscriberApiUtils.unwrapNullUnchecked(nextItem));
        return true;
    }
}

