/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.baremaps.collection.type.DataType;
import org.apache.baremaps.collection.type.GeometryDataType;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.MapDataType;
import org.apache.baremaps.collection.type.StringDataType;
import org.apache.baremaps.workflow.tasks.Entity;
import org.locationtech.jts.geom.Geometry;

public class EntityDataType
implements DataType<Entity> {
    private LongDataType idType = new LongDataType();
    private MapDataType<String, String> tagsType = new MapDataType<String, String>(new StringDataType(), new StringDataType());
    private GeometryDataType geometryType = new GeometryDataType();

    @Override
    public int size(Entity value) {
        int size = 0;
        size += this.idType.size();
        size += this.tagsType.size(value.getTags());
        return size += this.geometryType.size(value.getGeometry());
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Entity value) {
        buffer.putInt(position, this.size(value));
        this.idType.write(buffer, position += 4, value.getId());
        this.tagsType.write(buffer, position += this.idType.size(), value.getTags());
        this.geometryType.write(buffer, position += this.tagsType.size(value.getTags()), value.getGeometry());
    }

    @Override
    public Entity read(ByteBuffer buffer, int position) {
        long id = this.idType.read(buffer, position += 4);
        Object tags = this.tagsType.read(buffer, position += this.idType.size(id));
        Geometry geometry = this.geometryType.read(buffer, position += this.tagsType.size((Map<String, String>)tags));
        return new Entity(id, (Map<String, String>)tags, geometry);
    }
}

