/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.baremaps.database.tile.Tile;
import org.locationtech.jts.geom.Envelope;

class TileIterator
implements Iterator<Tile> {
    private final Envelope envelope;
    private final int minZoom;
    private final int maxZoom;
    private int z;
    private int x;
    private int y;

    public TileIterator(Envelope envelope, int minZoom, int maxZoom) {
        this.envelope = envelope;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.z = this.minZoom;
        Tile min = Tile.min(envelope, this.z);
        this.x = min.x();
        this.y = min.y();
    }

    @Override
    public boolean hasNext() {
        Tile max = Tile.max(this.envelope, this.z);
        return this.x <= max.x() && this.y <= max.y() && this.z <= this.maxZoom;
    }

    @Override
    public Tile next() {
        Tile tile = new Tile(this.x, this.y, this.z);
        Tile max = Tile.max(this.envelope, this.z);
        if (this.z > max.z()) {
            throw new NoSuchElementException();
        }
        if (this.x < max.x()) {
            ++this.x;
        } else if (this.y < max.y()) {
            ++this.y;
            Tile min = Tile.min(this.envelope, this.z);
            this.x = min.x();
        } else {
            ++this.z;
            Tile min = Tile.min(this.envelope, this.z);
            this.x = min.x();
            this.y = min.y();
        }
        return tile;
    }
}

