/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.workflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.server.ConfigReader;
import org.apache.baremaps.server.DefaultObjectMapper;
import org.apache.baremaps.workflow.Workflow;
import org.apache.baremaps.workflow.WorkflowExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="execute", description={"Execute a workflow."})
public class Execute
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Execute.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--file"}, paramLabel="FILE", description={"The workflow file."}, required=true)
    private Path file;

    @Override
    public Integer call() throws Exception {
        logger.info("Executing the workflow {}", (Object)this.file);
        ObjectMapper mapper = DefaultObjectMapper.defaultObjectMapper();
        ConfigReader configReader = new ConfigReader();
        Workflow workflow = (Workflow)mapper.readValue(configReader.read(this.file.toAbsolutePath()), Workflow.class);
        try (WorkflowExecutor executor = new WorkflowExecutor(workflow);){
            executor.execute().get();
        }
        logger.info("Finished executing the workflow {}", (Object)this.file);
        return 0;
    }
}

