/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.BlockingIterable;
import io.servicetalk.concurrent.BlockingIterator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.encoding.api.BufferEncoder;
import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.http.api.AbstractDelegatingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpMessageBodyUtils;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.DefaultStreamingHttpRequest;
import io.servicetalk.http.api.HttpMessageBodyIterable;
import io.servicetalk.http.api.HttpMessageBodyIterator;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.HttpStreamingDeserializer;
import io.servicetalk.http.api.HttpStreamingSerializer;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.TrailersTransformer;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class DefaultBlockingStreamingHttpRequest
extends AbstractDelegatingHttpRequest
implements BlockingStreamingHttpRequest {
    @Nullable
    private InputStream inputStream;

    DefaultBlockingStreamingHttpRequest(DefaultStreamingHttpRequest original) {
        super(original);
    }

    @Override
    public BlockingStreamingHttpRequest version(HttpProtocolVersion version) {
        this.original.version(version);
        return this;
    }

    @Override
    @Deprecated
    public BlockingStreamingHttpRequest encoding(ContentCodec encoding) {
        this.original.encoding(encoding);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest context(ContextMap context) {
        this.original.context(context);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest contentEncoding(@Nullable BufferEncoder encoder) {
        this.original.contentEncoding(encoder);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest method(HttpRequestMethod method) {
        this.original.method(method);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest requestTarget(String requestTarget) {
        this.original.requestTarget(requestTarget);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest requestTarget(String requestTarget, Charset encoding) {
        this.original.requestTarget(requestTarget, encoding);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest path(String path) {
        this.original.path(path);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest appendPathSegments(String ... segments) {
        this.original.appendPathSegments(segments);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest rawPath(String path) {
        this.original.rawPath(path);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest rawQuery(@Nullable String query) {
        this.original.rawQuery(query);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest query(@Nullable String query) {
        this.original.query(query);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest addQueryParameter(String key, String value) {
        this.original.addQueryParameter(key, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest addQueryParameters(String key, Iterable<String> values) {
        this.original.addQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest addQueryParameters(String key, String ... values) {
        this.original.addQueryParameters(key, values);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest setQueryParameter(String key, String value) {
        this.original.setQueryParameter(key, value);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest setQueryParameters(String key, Iterable<String> values) {
        this.original.setQueryParameters(key, (Iterable)values);
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest setQueryParameters(String key, String ... values) {
        this.original.setQueryParameters(key, values);
        return this;
    }

    @Override
    public BlockingIterable<Buffer> payloadBody() {
        return this.original.payloadBody().toIterable();
    }

    @Override
    public InputStream payloadBodyInputStream() {
        if (this.inputStream == null) {
            this.inputStream = BlockingStreamingHttpRequest.super.payloadBodyInputStream();
        }
        return this.inputStream;
    }

    @Override
    public <T> BlockingIterable<T> payloadBody(HttpStreamingDeserializer<T> deserializer) {
        return deserializer.deserialize(this.headers(), this.payloadBody(), this.original.payloadHolder().allocator());
    }

    @Override
    public HttpMessageBodyIterable<Buffer> messageBody() {
        return BlockingStreamingHttpMessageBodyUtils.newMessageBody((BlockingIterable<Object>)this.original.messageBody().toIterable());
    }

    @Override
    public <T> HttpMessageBodyIterable<T> messageBody(HttpStreamingDeserializer<T> deserializer) {
        return BlockingStreamingHttpMessageBodyUtils.newMessageBody((BlockingIterable<Object>)this.original.messageBody().toIterable(), this.headers(), deserializer, this.original.payloadHolder().allocator());
    }

    @Override
    public BlockingStreamingHttpRequest payloadBody(Iterable<Buffer> payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromIterable(payloadBody));
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest payloadBody(InputStream payloadBody) {
        this.original.payloadBody((Publisher<Buffer>)Publisher.fromInputStream((InputStream)payloadBody).map(bytes -> this.original.payloadHolder().allocator().wrap(bytes)));
        return this;
    }

    @Override
    public BlockingStreamingHttpRequest messageBody(HttpMessageBodyIterable<Buffer> messageBody) {
        this.original.payloadHolder().messageBody(Publisher.defer(() -> {
            BlockingIterator body = messageBody.iterator();
            return Publisher.fromIterable(() -> DefaultBlockingStreamingHttpRequest.lambda$null$1((HttpMessageBodyIterator)body)).map(o -> o).concat(Publisher.defer(() -> DefaultBlockingStreamingHttpRequest.lambda$null$3((HttpMessageBodyIterator)body)));
        }));
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpRequest messageBody(HttpMessageBodyIterable<T> messageBody, HttpStreamingSerializer<T> serializer) {
        this.original.payloadHolder().messageBody(Publisher.defer(() -> {
            BlockingIterator body = messageBody.iterator();
            return Publisher.from(serializer.serialize(this.headers(), () -> DefaultBlockingStreamingHttpRequest.lambda$null$5((HttpMessageBodyIterator)body), this.original.payloadHolder().allocator())).map(o -> o).concat(Publisher.defer(() -> DefaultBlockingStreamingHttpRequest.lambda$null$7((HttpMessageBodyIterator)body)));
        }));
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpRequest payloadBody(Iterable<T> payloadBody, HttpSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    public <T> BlockingStreamingHttpRequest payloadBody(Iterable<T> payloadBody, HttpStreamingSerializer<T> serializer) {
        this.original.payloadBody(Publisher.fromIterable(payloadBody), serializer);
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpRequest transformPayloadBody(Function<BlockingIterable<Buffer>, BlockingIterable<T>> transformer, HttpSerializer<T> serializer) {
        this.original.transformPayloadBody((Publisher<Buffer> bufferPublisher) -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))), serializer);
        return this;
    }

    @Override
    @Deprecated
    public BlockingStreamingHttpRequest transformPayloadBody(UnaryOperator<BlockingIterable<Buffer>> transformer) {
        this.original.transformPayloadBody(bufferPublisher -> Publisher.fromIterable((Iterable)((Iterable)transformer.apply(bufferPublisher.toIterable()))));
        return this;
    }

    @Override
    @Deprecated
    public <T> BlockingStreamingHttpRequest transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.original.transform(trailersTransformer);
        return this;
    }

    @Override
    public Single<HttpRequest> toRequest() {
        return this.toStreamingRequest().toRequest();
    }

    @Override
    public StreamingHttpRequest toStreamingRequest() {
        return this.original;
    }

    private static /* synthetic */ Publisher lambda$null$7(HttpMessageBodyIterator body) {
        return Publisher.from((Object)body.trailers()).filter(Objects::nonNull);
    }

    private static /* synthetic */ BlockingIterator lambda$null$5(HttpMessageBodyIterator body) {
        return body;
    }

    private static /* synthetic */ Publisher lambda$null$3(HttpMessageBodyIterator body) {
        return Publisher.from((Object)body.trailers()).filter(Objects::nonNull);
    }

    private static /* synthetic */ Iterator lambda$null$1(HttpMessageBodyIterator body) {
        return body;
    }
}

