/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.api;

import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.api.SslProvider;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public abstract class DelegatingSslConfig<T extends SslConfig>
implements SslConfig {
    private final T delegate;

    protected DelegatingSslConfig(T delegate) {
        this.delegate = (SslConfig)Objects.requireNonNull(delegate);
    }

    protected T delegate() {
        return this.delegate;
    }

    @Override
    @Nullable
    public TrustManagerFactory trustManagerFactory() {
        return this.delegate.trustManagerFactory();
    }

    @Override
    @Nullable
    public Supplier<InputStream> trustCertChainSupplier() {
        return this.delegate.trustCertChainSupplier();
    }

    @Override
    @Nullable
    public KeyManagerFactory keyManagerFactory() {
        return this.delegate.keyManagerFactory();
    }

    @Override
    @Nullable
    public Supplier<InputStream> keyCertChainSupplier() {
        return this.delegate.keyCertChainSupplier();
    }

    @Override
    @Nullable
    public Supplier<InputStream> keySupplier() {
        return this.delegate.keySupplier();
    }

    @Override
    @Nullable
    public String keyPassword() {
        return this.delegate.keyPassword();
    }

    @Override
    @Nullable
    public List<String> sslProtocols() {
        return this.delegate.sslProtocols();
    }

    @Override
    @Nullable
    public List<String> alpnProtocols() {
        return this.delegate.alpnProtocols();
    }

    @Override
    @Nullable
    public List<String> ciphers() {
        return this.delegate.ciphers();
    }

    @Override
    public long sessionCacheSize() {
        return this.delegate.sessionCacheSize();
    }

    @Override
    public long sessionTimeout() {
        return this.delegate.sessionTimeout();
    }

    @Override
    @Nullable
    public SslProvider provider() {
        return this.delegate.provider();
    }
}

