/*
 * Decompiled with CFR 0.152.
 */
package org.wololo.flatgeobuf;

import java.util.Objects;
import org.locationtech.jts.geom.Envelope;

public class NodeItem {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;
    public long offset;

    public NodeItem(double minX, double minY, double maxX, double maxY, long offset) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.offset = offset;
    }

    public NodeItem(double minX, double minY, double maxX, double maxY) {
        this(minX, minY, maxX, maxY, 0L);
    }

    public NodeItem(long offset) {
        this(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, offset);
    }

    public double width() {
        return this.maxX - this.minX;
    }

    public double height() {
        return this.maxY - this.minY;
    }

    public static NodeItem sum(NodeItem a, NodeItem b) {
        a.expand(b);
        return a;
    }

    public NodeItem expand(NodeItem nodeItem) {
        if (nodeItem.minX < this.minX) {
            this.minX = nodeItem.minX;
        }
        if (nodeItem.minY < this.minY) {
            this.minY = nodeItem.minY;
        }
        if (nodeItem.maxX > this.maxX) {
            this.maxX = nodeItem.maxX;
        }
        if (nodeItem.maxY > this.maxY) {
            this.maxY = nodeItem.maxY;
        }
        return this;
    }

    public boolean intersects(NodeItem nodeItem) {
        if (nodeItem.minX > this.maxX) {
            return false;
        }
        if (nodeItem.minY > this.maxY) {
            return false;
        }
        if (nodeItem.maxX < this.minX) {
            return false;
        }
        return !(nodeItem.maxY < this.minY);
    }

    public Envelope toEnvelope() {
        return new Envelope(this.minX, this.maxX, this.minY, this.maxY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeItem nodeItem = (NodeItem)o;
        return Double.compare(nodeItem.minX, this.minX) == 0 && Double.compare(nodeItem.minY, this.minY) == 0 && Double.compare(nodeItem.maxX, this.maxX) == 0 && Double.compare(nodeItem.maxY, this.maxY) == 0 && this.offset == nodeItem.offset;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.maxX, this.maxY, this.offset);
    }
}

