/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.serializer.utils;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.serializer.api.SerializationException;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.serializer.utils.FramedDeserializerOperator;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;

public final class FixedLengthStreamingSerializer<T>
implements StreamingSerializerDeserializer<T> {
    private final SerializerDeserializer<T> serializer;
    private final ToIntFunction<T> bytesEstimator;

    public FixedLengthStreamingSerializer(SerializerDeserializer<T> serializer, ToIntFunction<T> bytesEstimator) {
        this.serializer = Objects.requireNonNull(serializer);
        this.bytesEstimator = Objects.requireNonNull(bytesEstimator);
    }

    public Publisher<T> deserialize(Publisher<Buffer> serializedData, BufferAllocator allocator) {
        return serializedData.liftSync(new FramedDeserializerOperator<T>(this.serializer, () -> new LengthDeframer(), allocator)).flatMapConcatIterable(Function.identity());
    }

    public Publisher<Buffer> serialize(Publisher<T> toSerialize, BufferAllocator allocator) {
        return toSerialize.map(t -> {
            Buffer buffer = allocator.newBuffer(4 + this.bytesEstimator.applyAsInt(t));
            int beforeWriterIndex = buffer.writerIndex();
            buffer.writerIndex(beforeWriterIndex + 4);
            this.serializer.serialize(t, allocator, buffer);
            buffer.setInt(beforeWriterIndex, buffer.writerIndex() - beforeWriterIndex - 4);
            return buffer;
        });
    }

    private static final class LengthDeframer
    implements BiFunction<Buffer, BufferAllocator, Buffer> {
        private int expectedLength = -1;

        private LengthDeframer() {
        }

        @Override
        @Nullable
        public Buffer apply(Buffer buffer, BufferAllocator allocator) {
            if (this.expectedLength < 0) {
                if (buffer.readableBytes() < 4) {
                    return null;
                }
                this.expectedLength = buffer.readInt();
                if (this.expectedLength < 0) {
                    throw new SerializationException("Invalid length: " + this.expectedLength);
                }
            }
            if (buffer.readableBytes() < this.expectedLength) {
                return null;
            }
            Buffer result = buffer.readBytes(this.expectedLength);
            this.expectedLength = -1;
            return result;
        }
    }
}

