/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.mapper.immutables;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.JdbiOptionals;
import org.jdbi.v3.core.internal.exceptions.CheckedSupplier;
import org.jdbi.v3.core.internal.exceptions.Unchecked;
import org.jdbi.v3.core.mapper.reflect.internal.BuilderPojoPropertiesFactory;
import org.jdbi.v3.core.mapper.reflect.internal.ModifiablePojoPropertiesFactory;
import org.jdbi.v3.core.mapper.reflect.internal.PojoPropertiesFactory;
import org.jdbi.v3.core.mapper.reflect.internal.PojoTypes;
import org.jdbi.v3.meta.Beta;

@Beta
public class JdbiImmutables
implements JdbiConfig<JdbiImmutables> {
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public <S> JdbiImmutables registerImmutable(Class<S> spec) {
        Class impl = JdbiImmutables.classByPrefix("Immutable", spec);
        return this.registerImmutable(spec, impl, (Supplier)JdbiOptionals.findFirstPresent(() -> JdbiImmutables.nullaryMethodOf(spec, "builder"), () -> JdbiImmutables.nullaryMethodOf(impl, "builder")).orElseThrow(() -> new IllegalArgumentException("Neither " + spec + " nor " + impl + " have a 'builder' method")));
    }

    public JdbiImmutables registerImmutable(Class<?> ... specs) {
        return this.registerImmutable(Arrays.asList(specs));
    }

    public JdbiImmutables registerImmutable(Iterable<Class<?>> specs) {
        specs.forEach(this::registerImmutable);
        return this;
    }

    public <S, I extends S> JdbiImmutables registerImmutable(Class<S> spec, Class<I> impl, Supplier<?> builder) {
        return this.register(spec, impl, BuilderPojoPropertiesFactory.builder(spec, builder));
    }

    public JdbiImmutables registerModifiable(Class<?> ... specs) {
        return this.registerModifiable(Arrays.asList(specs));
    }

    public JdbiImmutables registerModifiable(Iterable<Class<?>> specs) {
        specs.forEach(this::registerModifiable);
        return this;
    }

    public <S> JdbiImmutables registerModifiable(Class<S> spec) {
        Class impl = JdbiImmutables.classByPrefix("Modifiable", spec);
        return this.registerModifiable(spec, impl, JdbiImmutables.nullaryMethodOf(impl, "create").orElseGet(() -> JdbiImmutables.constructorOf(impl)));
    }

    public <S, M extends S> JdbiImmutables registerModifiable(Class<S> spec, Class<M> impl, Supplier<?> constructor) {
        return this.register(spec, impl, ModifiablePojoPropertiesFactory.modifiable(spec, impl, () -> impl.cast(constructor.get())));
    }

    private JdbiImmutables register(Class<?> spec, Class<?> impl, PojoPropertiesFactory factory) {
        this.registry.get(PojoTypes.class).register(spec, factory).register(impl, factory);
        return this;
    }

    private static Optional<Supplier<?>> nullaryMethodOf(Class<?> impl, String methodName) {
        try {
            return Optional.of(Unchecked.supplier((CheckedSupplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)MethodHandles.lookup().unreflect(impl.getMethod(methodName, new Class[0])))));
        }
        catch (ReflectiveOperationException e) {
            return Optional.empty();
        }
    }

    private static <S> Supplier<S> constructorOf(Class<S> impl) {
        try {
            return Unchecked.supplier((CheckedSupplier<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)MethodHandles.lookup().findConstructor(impl, MethodType.methodType(Void.TYPE))));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Couldn't find public constructor of " + impl, e);
        }
    }

    private static <S, Sub extends S> Class<? extends S> classByPrefix(String prefix, Class<S> spec) {
        String implName = spec.getPackage().getName() + '.' + prefix + spec.getSimpleName();
        try {
            return Class.forName(implName).asSubclass(spec);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't locate default implementation class " + implName, e);
        }
    }

    @Override
    public JdbiImmutables createCopy() {
        return new JdbiImmutables();
    }
}

