/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.disaster;

import org.apache.ignite.raft.jraft.core.State;

public enum LocalPartitionStateEnum {
    UNAVAILABLE,
    HEALTHY,
    INITIALIZING,
    INSTALLING_SNAPSHOT,
    CATCHING_UP,
    BROKEN;

    private static final LocalPartitionStateEnum[] VALUES;

    public static LocalPartitionStateEnum convert(State raftNodeState) {
        switch (raftNodeState) {
            case STATE_LEADER: 
            case STATE_TRANSFERRING: 
            case STATE_CANDIDATE: 
            case STATE_FOLLOWER: {
                return HEALTHY;
            }
            case STATE_ERROR: {
                return BROKEN;
            }
            case STATE_UNINITIALIZED: {
                return INITIALIZING;
            }
            case STATE_SHUTTING: 
            case STATE_SHUTDOWN: 
            case STATE_END: {
                return UNAVAILABLE;
            }
        }
        return BROKEN;
    }

    public static LocalPartitionStateEnum fromOrdinal(int ordinal) throws IllegalArgumentException {
        if (ordinal < 0 || ordinal >= VALUES.length) {
            throw new IllegalArgumentException("No enum constant from ordinal: " + ordinal);
        }
        return VALUES[ordinal];
    }

    static {
        VALUES = LocalPartitionStateEnum.values();
    }
}

