/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.raft.service.RaftCommandRunner;
import org.apache.ignite.internal.replicator.ReplicaResult;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;
import org.apache.ignite.internal.replicator.listener.ReplicaListener;
import org.apache.ignite.internal.replicator.message.ReplicaRequest;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TableAware;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.VisibleForTesting;

public class ZonePartitionReplicaListener
implements ReplicaListener {
    private static final TxMessagesFactory TX_MESSAGES_FACTORY = new TxMessagesFactory();
    private static final IgniteLogger LOG = Loggers.forClass(ZonePartitionReplicaListener.class);
    private final Map<TablePartitionId, ReplicaListener> replicas = new ConcurrentHashMap<TablePartitionId, ReplicaListener>();
    private final RaftCommandRunner raftClient;

    public ZonePartitionReplicaListener(RaftCommandRunner raftClient) {
        this.raftClient = raftClient;
    }

    public CompletableFuture<ReplicaResult> invoke(ReplicaRequest request, UUID senderId) {
        int partitionId;
        if (!(request instanceof TableAware)) {
            if (request instanceof TxFinishReplicaRequest) {
                TxFinishReplicaRequest txFinishReplicaRequest = (TxFinishReplicaRequest)request;
                TxFinishReplicaRequest requestForTableListener = TX_MESSAGES_FACTORY.txFinishReplicaRequest().txId(txFinishReplicaRequest.txId()).commitPartitionId(txFinishReplicaRequest.commitPartitionId()).timestamp(txFinishReplicaRequest.timestamp()).groupId((ReplicationGroupIdMessage)txFinishReplicaRequest.commitPartitionId()).groups(txFinishReplicaRequest.groups()).commit(txFinishReplicaRequest.commit()).commitTimestamp(txFinishReplicaRequest.commitTimestamp()).enlistmentConsistencyToken(txFinishReplicaRequest.enlistmentConsistencyToken()).build();
                return this.replicas.get(txFinishReplicaRequest.commitPartitionId().asTablePartitionId()).invoke((ReplicaRequest)requestForTableListener, senderId);
            }
            LOG.debug("Non table request is not supported by the zone partition yet " + String.valueOf(request), new Object[0]);
            return CompletableFutures.nullCompletedFuture();
        }
        ReplicationGroupId replicationGroupId = request.groupId().asReplicationGroupId();
        if (replicationGroupId instanceof TablePartitionId) {
            partitionId = ((TablePartitionId)replicationGroupId).partitionId();
        } else if (replicationGroupId instanceof ZonePartitionId) {
            partitionId = ((ZonePartitionId)replicationGroupId).partitionId();
        } else {
            throw new IllegalArgumentException("Requests with replication group type " + String.valueOf(request.groupId().getClass()) + " is not supported");
        }
        return this.replicas.get(new TablePartitionId(((TableAware)request).tableId(), partitionId)).invoke(request, senderId);
    }

    public RaftCommandRunner raftClient() {
        return this.raftClient;
    }

    public void addTableReplicaListener(TablePartitionId partitionId, Function<RaftCommandRunner, ReplicaListener> replicaListener) {
        this.replicas.put(partitionId, replicaListener.apply(this.raftClient));
    }

    @VisibleForTesting
    public Map<TablePartitionId, ReplicaListener> tableReplicaListeners() {
        return this.replicas;
    }

    public void onShutdown() {
        this.replicas.forEach((id, listener) -> {
            try {
                listener.onShutdown();
            }
            catch (Throwable th) {
                LOG.error("Error during table partition listener stop for [tableId=" + id.tableId() + ", partitionId=" + id.partitionId() + "].", th);
            }
        });
    }
}

