/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.tx.InternalTransaction;

class TransactionExpirationRegistry {
    private static final IgniteLogger LOG = Loggers.forClass(TransactionExpirationRegistry.class);
    private final NavigableMap<Long, Object> txsByExpirationTime = new ConcurrentSkipListMap<Long, Object>();
    private final Map<InternalTransaction, Long> expirationTimeByTx = new ConcurrentHashMap<InternalTransaction, Long>();
    private final ReadWriteLock watermarkLock = new ReentrantReadWriteLock();
    private volatile long watermark = Long.MIN_VALUE;

    TransactionExpirationRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(InternalTransaction tx, long txExpirationTime) {
        if (this.isExpired(txExpirationTime)) {
            TransactionExpirationRegistry.abortTransaction(tx);
            return;
        }
        this.watermarkLock.readLock().lock();
        try {
            if (this.isExpired(txExpirationTime)) {
                TransactionExpirationRegistry.abortTransaction(tx);
                return;
            }
            this.txsByExpirationTime.compute(txExpirationTime, (k, txOrSet) -> {
                HashSet<InternalTransaction> txsExpiringAtTs;
                if (txOrSet == null) {
                    return tx;
                }
                if (txOrSet instanceof Set) {
                    txsExpiringAtTs = (HashSet<InternalTransaction>)txOrSet;
                } else {
                    txsExpiringAtTs = new HashSet<InternalTransaction>();
                    txsExpiringAtTs.add((InternalTransaction)txOrSet);
                }
                txsExpiringAtTs.add(tx);
                return txsExpiringAtTs;
            });
            this.expirationTimeByTx.put(tx, txExpirationTime);
        }
        finally {
            this.watermarkLock.readLock().unlock();
        }
    }

    private boolean isExpired(long expirationTime) {
        return expirationTime <= this.watermark;
    }

    private static void abortTransaction(InternalTransaction tx) {
        tx.rollbackAsync().whenComplete((res, ex) -> {
            if (ex != null) {
                LOG.error("Transaction abort due to timeout failed [txId={}]", ex, new Object[]{tx.id()});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireUpTo(long expirationTime) {
        ArrayList transactionsAndSetsToExpire;
        this.watermarkLock.writeLock().lock();
        try {
            NavigableMap<Long, Object> headMap = this.txsByExpirationTime.headMap(expirationTime, true);
            transactionsAndSetsToExpire = new ArrayList(headMap.values());
            headMap.clear();
            this.watermark = expirationTime;
        }
        finally {
            this.watermarkLock.writeLock().unlock();
        }
        for (Object txOrSet : transactionsAndSetsToExpire) {
            if (txOrSet instanceof Set) {
                for (InternalTransaction tx : (Set)txOrSet) {
                    this.expirationTimeByTx.remove(tx);
                    TransactionExpirationRegistry.abortTransaction(tx);
                }
                continue;
            }
            InternalTransaction tx = (InternalTransaction)txOrSet;
            this.expirationTimeByTx.remove(tx);
            TransactionExpirationRegistry.abortTransaction(tx);
        }
    }

    void abortAllRegistered() {
        this.expireUpTo(Long.MAX_VALUE);
    }

    void unregister(InternalTransaction tx) {
        Long expirationTime = this.expirationTimeByTx.remove(tx);
        if (expirationTime != null) {
            this.txsByExpirationTime.computeIfPresent(expirationTime, (k, txOrSet) -> {
                if (txOrSet instanceof Set) {
                    Set set = (Set)txOrSet;
                    set.remove(tx);
                    return set.size() == 1 ? set.iterator().next() : set;
                }
                return null;
            });
        }
    }
}

