/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.Colocate;
import org.apache.ignite.internal.catalog.sql.Column;
import org.apache.ignite.internal.catalog.sql.ColumnTypeImpl;
import org.apache.ignite.internal.catalog.sql.Constraint;
import org.apache.ignite.internal.catalog.sql.CreateIndexImpl;
import org.apache.ignite.internal.catalog.sql.IndexColumnImpl;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPartCollection;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.catalog.sql.Zone;
import org.apache.ignite.sql.IgniteSql;

class CreateTableImpl
extends AbstractCatalogQuery<Name> {
    private Name tableName;
    private boolean ifNotExists;
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private Colocate colocate;
    private Zone zone;
    private final List<CreateIndexImpl> indexes = new ArrayList<CreateIndexImpl>();

    CreateTableImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.tableName;
    }

    CreateTableImpl name(String ... names) {
        Objects.requireNonNull(names, "Table name must not be null.");
        this.tableName = new Name(names);
        return this;
    }

    CreateTableImpl ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    CreateTableImpl addColumn(String name, String definition) {
        Objects.requireNonNull(name, "Column name must not be null.");
        Objects.requireNonNull(definition, "Column type must not be null.");
        this.columns.add(new Column(name, definition));
        return this;
    }

    CreateTableImpl addColumn(String name, ColumnType<?> type) {
        Objects.requireNonNull(name, "Column name must not be null.");
        Objects.requireNonNull(type, "Column type must not be null.");
        this.columns.add(new Column(name, ColumnTypeImpl.wrap(type)));
        return this;
    }

    CreateTableImpl primaryKey(String columnList) {
        return this.primaryKey(IndexType.DEFAULT, columnList);
    }

    CreateTableImpl primaryKey(IndexType type, String columnList) {
        return this.primaryKey(type, IndexColumnImpl.parseIndexColumnList(columnList));
    }

    CreateTableImpl primaryKey(IndexType type, List<ColumnSorted> columns) {
        Objects.requireNonNull(columns, "PK columns must not be null.");
        this.constraints.add(new Constraint().primaryKey(type, columns));
        return this;
    }

    CreateTableImpl colocateBy(String columnList) {
        return this.colocateBy(QueryUtils.splitByComma(columnList));
    }

    CreateTableImpl colocateBy(String ... columns) {
        return this.colocateBy(Arrays.asList(columns));
    }

    CreateTableImpl colocateBy(List<String> columns) {
        Objects.requireNonNull(columns, "Colocate columns must not be null.");
        this.colocate = new Colocate(columns);
        return this;
    }

    CreateTableImpl zone(String zone) {
        Objects.requireNonNull(zone, "Zone name must not be null.");
        this.zone = new Zone(zone.toUpperCase());
        return this;
    }

    CreateTableImpl addIndex(String name, String columnList) {
        return this.addIndex(name, null, columnList);
    }

    CreateTableImpl addIndex(String name, IndexType type, String columnList) {
        return this.addIndex(name, type, IndexColumnImpl.parseIndexColumnList(columnList));
    }

    CreateTableImpl addIndex(String name, IndexType type, ColumnSorted ... columns) {
        return this.addIndex(name, type, Arrays.asList(columns));
    }

    CreateTableImpl addIndex(String name, IndexType type, List<ColumnSorted> columns) {
        Objects.requireNonNull(name, "Index name must not be null.");
        Objects.requireNonNull(columns, "Index columns list must not be null.");
        this.indexes.add(new CreateIndexImpl(this.sql).ifNotExists().name(name).using(type).on(this.tableName, columns));
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.columns.isEmpty()) {
            throw new IllegalArgumentException("Columns list must not be empty.");
        }
        ctx.sql("CREATE TABLE ");
        if (this.ifNotExists) {
            ctx.sql("IF NOT EXISTS ");
        }
        ctx.visit(this.tableName);
        ctx.sqlIndentStart(" (");
        ctx.visit(QueryPartCollection.partsList(this.columns));
        if (!this.constraints.isEmpty()) {
            ctx.sql(", ");
            ctx.visit(QueryPartCollection.partsList(this.constraints));
        }
        ctx.sql(")");
        if (this.colocate != null) {
            ctx.sql(" ").visit(this.colocate);
        }
        if (this.zone != null) {
            ctx.sql(" ").visit(this.zone);
        }
        ctx.sql(";");
        for (CreateIndexImpl index : this.indexes) {
            ctx.formatSeparator().visit(index);
        }
    }
}

