/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.systemviews;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;

public class TablesSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        return List.of(TablesSystemViewProvider.getTablesSystemView(catalogSupplier), TablesSystemViewProvider.getTableColumnsSystemView(catalogSupplier));
    }

    private static SystemView<?> getTablesSystemView(Supplier<Catalog> catalogSupplier) {
        Iterable tablesData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.tables().stream().map(table -> {
                String schemaName = Objects.requireNonNull(catalog.schema(table.schemaId()), "Schema must be not null.").name();
                String zoneName = Objects.requireNonNull(catalog.zone(table.zoneId()), "Zone must be not null.").name();
                return new TableWithSchemaAndZoneName((CatalogTableDescriptor)table, schemaName, zoneName);
            }).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(tablesData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("TABLES")).addColumn("SCHEMA", NativeTypes.STRING, entry -> entry.schemaName)).addColumn("NAME", NativeTypes.STRING, entry -> entry.table.name())).addColumn("ID", NativeTypes.INT32, entry -> entry.table.id())).addColumn("PK_INDEX_ID", NativeTypes.INT32, entry -> entry.table.primaryKeyIndexId())).addColumn("ZONE", NativeTypes.STRING, entry -> entry.zoneName)).addColumn("STORAGE_PROFILE", NativeTypes.STRING, entry -> entry.table.storageProfile())).addColumn("COLOCATION_KEY_INDEX", NativeTypes.STRING, entry -> TablesSystemViewProvider.concatColumns(entry.table.colocationColumns()))).dataProvider(viewDataPublisher)).build();
    }

    private static String concatColumns(List<String> columns) {
        if (columns == null || columns.isEmpty()) {
            return "NULL";
        }
        return String.join((CharSequence)", ", columns);
    }

    private static SystemView<?> getTableColumnsSystemView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.tables().stream().flatMap(table -> table.columns().stream().map(columnDescriptor -> new ColumnWithTableId(catalog.schema(table.schemaId()).name(), table.name(), table.id(), (CatalogTableColumnDescriptor)columnDescriptor))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("TABLE_COLUMNS")).addColumn("SCHEMA", NativeTypes.STRING, entry -> entry.schema)).addColumn("TABLE_NAME", NativeTypes.STRING, entry -> entry.tableName)).addColumn("TABLE_ID", NativeTypes.INT32, entry -> entry.tableId)).addColumn("COLUMN_NAME", NativeTypes.STRING, entry -> entry.descriptor.name())).addColumn("TYPE", NativeTypes.STRING, entry -> entry.descriptor.type().name())).addColumn("NULLABLE", NativeTypes.BOOLEAN, entry -> entry.descriptor.nullable())).addColumn("PREC", NativeTypes.INT32, entry -> entry.descriptor.precision())).addColumn("SCALE", NativeTypes.INT32, entry -> entry.descriptor.scale())).addColumn("LENGTH", NativeTypes.INT32, entry -> entry.descriptor.length())).dataProvider(viewDataPublisher)).build();
    }

    private static class ColumnWithTableId {
        private final CatalogTableColumnDescriptor descriptor;
        private final String tableName;
        private final String schema;
        private final int tableId;

        private ColumnWithTableId(String schema, String tableName, int tableId, CatalogTableColumnDescriptor descriptor) {
            this.schema = schema;
            this.tableName = tableName;
            this.descriptor = descriptor;
            this.tableId = tableId;
        }
    }

    private static class TableWithSchemaAndZoneName {
        private final CatalogTableDescriptor table;
        private final String schemaName;
        private final String zoneName;

        private TableWithSchemaAndZoneName(CatalogTableDescriptor table, String schemaName, String zoneName) {
            this.table = table;
            this.schemaName = schemaName;
            this.zoneName = zoneName;
        }
    }
}

