/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

public class CatalogTableSchemaVersions {
    public static final CatalogObjectSerializer<CatalogTableSchemaVersions> SERIALIZER = new TableSchemaVersionsSerializer();
    private final int base;
    private final TableVersion[] versions;

    CatalogTableSchemaVersions(TableVersion ... versions) {
        this(1, versions);
    }

    private CatalogTableSchemaVersions(int base, TableVersion ... versions) {
        this.base = base;
        this.versions = versions;
    }

    public int earliestVersion() {
        return this.base;
    }

    public int latestVersion() {
        return this.base + this.versions.length - 1;
    }

    @Nullable
    public TableVersion get(int version) {
        if (version < this.base || version >= this.base + this.versions.length) {
            return null;
        }
        return this.versions[version - this.base];
    }

    public CatalogTableSchemaVersions append(TableVersion tableVersion, int version) {
        assert (version == this.latestVersion() + 1);
        return new CatalogTableSchemaVersions(this.base, (TableVersion[])ArrayUtils.concat((Object[])this.versions, (Object[])new TableVersion[]{tableVersion}));
    }

    public static class TableVersion {
        private final List<CatalogTableColumnDescriptor> columns;

        public TableVersion(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
        }

        public List<CatalogTableColumnDescriptor> columns() {
            return Collections.unmodifiableList(this.columns);
        }
    }

    private static class TableSchemaVersionsSerializer
    implements CatalogObjectSerializer<CatalogTableSchemaVersions> {
        private TableSchemaVersionsSerializer() {
        }

        @Override
        public CatalogTableSchemaVersions readFrom(IgniteDataInput input) throws IOException {
            TableVersion[] versions = CatalogSerializationUtils.readArray(TableVersionSerializer.INSTANCE, input, TableVersion.class);
            int base = input.readVarIntAsInt();
            return new CatalogTableSchemaVersions(base, versions);
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions tabVersions, IgniteDataOutput output) throws IOException {
            CatalogSerializationUtils.writeArray(tabVersions.versions, TableVersionSerializer.INSTANCE, output);
            output.writeVarInt((long)tabVersions.base);
        }
    }

    private static class TableVersionSerializer
    implements CatalogObjectSerializer<TableVersion> {
        static CatalogObjectSerializer<TableVersion> INSTANCE = new TableVersionSerializer();

        private TableVersionSerializer() {
        }

        @Override
        public TableVersion readFrom(IgniteDataInput input) throws IOException {
            List<CatalogTableColumnDescriptor> columns = CatalogSerializationUtils.readList(CatalogTableColumnDescriptor.SERIALIZER, input);
            return new TableVersion(columns);
        }

        @Override
        public void writeTo(TableVersion tableVersion, IgniteDataOutput output) throws IOException {
            CatalogSerializationUtils.writeList(tableVersion.columns(), CatalogTableColumnDescriptor.SERIALIZER, output);
        }
    }
}

