/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.compute.AnyNodeJobTarget;
import org.apache.ignite.compute.ColocatedJobTarget;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.table.Tuple;
import org.apache.ignite.table.mapper.Mapper;

public interface JobTarget {
    public static JobTarget node(ClusterNode node) {
        return new AnyNodeJobTarget(Set.of(node));
    }

    public static JobTarget anyNode(ClusterNode ... nodes) {
        return new AnyNodeJobTarget(Set.of(nodes));
    }

    public static JobTarget anyNode(Collection<ClusterNode> nodes) {
        return new AnyNodeJobTarget(new HashSet<ClusterNode>(nodes));
    }

    public static JobTarget anyNode(Set<ClusterNode> nodes) {
        return new AnyNodeJobTarget(nodes);
    }

    public static JobTarget colocated(String tableName, Tuple key) {
        return new ColocatedJobTarget(tableName, key, null);
    }

    public static <K> JobTarget colocated(String tableName, K key, Mapper<K> keyMapper) {
        return new ColocatedJobTarget(tableName, key, keyMapper);
    }
}

