/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomTypeSpec;

public final class IgniteCustomTypeCoercionRules {
    private final Map<String, Set<SqlTypeName>> canCastFrom;

    IgniteCustomTypeCoercionRules(Map<String, IgniteCustomTypeSpec> typeSpecs, Map<String, Set<SqlTypeName>> canCastFrom) {
        for (Map.Entry<String, Set<SqlTypeName>> rule : canCastFrom.entrySet()) {
            String typeName = rule.getKey();
            if (typeSpecs.containsKey(typeName)) continue;
            String error = IgniteStringFormatter.format((String)"Unable to define type coercion rule. Unexpected custom type: {}. Rules: {}. Known types: {}", (Object[])new Object[]{typeName, rule.getValue(), typeSpecs.keySet()});
            throw new IllegalArgumentException(error);
        }
        this.canCastFrom = canCastFrom;
    }

    public boolean needToCast(RelDataType fromType, IgniteCustomType toType) {
        Set<SqlTypeName> rules = this.canCastFrom(toType.getCustomTypeName());
        return rules.contains(fromType.getSqlTypeName());
    }

    public Set<SqlTypeName> canCastFrom(String typeName) {
        return this.canCastFrom.getOrDefault(typeName, Collections.emptySet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Set<SqlTypeName>> canCastFrom = new HashMap<String, Set<SqlTypeName>>();

        Builder() {
        }

        public Builder addRule(String typeName, SqlTypeName to) {
            Set rules = this.canCastFrom.computeIfAbsent(typeName, k -> EnumSet.noneOf(SqlTypeName.class));
            rules.add(to);
            return this;
        }

        public Builder addRules(String typeName, Collection<SqlTypeName> typeNames) {
            Set rules = this.canCastFrom.computeIfAbsent(typeName, k -> EnumSet.noneOf(SqlTypeName.class));
            rules.addAll(typeNames);
            return this;
        }

        public IgniteCustomTypeCoercionRules build(Map<String, IgniteCustomTypeSpec> typeSpecs) {
            return new IgniteCustomTypeCoercionRules(typeSpecs, this.canCastFrom);
        }
    }
}

