/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDdl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlDdlNodes;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAddColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAddColumnCommandBuilder;
import org.apache.ignite.internal.catalog.commands.AlterTableAlterColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAlterColumnCommandBuilder;
import org.apache.ignite.internal.catalog.commands.AlterTableDropColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableDropColumnCommandBuilder;
import org.apache.ignite.internal.catalog.commands.AlterZoneCommand;
import org.apache.ignite.internal.catalog.commands.AlterZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.AlterZoneSetDefaultCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateHashIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateSchemaCommand;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommand;
import org.apache.ignite.internal.catalog.commands.CreateSortedIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite.internal.catalog.commands.CreateTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.commands.DeferredDefaultValue;
import org.apache.ignite.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite.internal.catalog.commands.DropIndexCommandBuilder;
import org.apache.ignite.internal.catalog.commands.DropSchemaCommand;
import org.apache.ignite.internal.catalog.commands.DropTableCommand;
import org.apache.ignite.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite.internal.catalog.commands.DropZoneCommand;
import org.apache.ignite.internal.catalog.commands.DropZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.RenameZoneCommand;
import org.apache.ignite.internal.catalog.commands.RenameZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.TableHashPrimaryKey;
import org.apache.ignite.internal.catalog.commands.TablePrimaryKey;
import org.apache.ignite.internal.catalog.commands.TableSortedPrimaryKey;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.prepare.IgnitePlanner;
import org.apache.ignite.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite.internal.sql.engine.prepare.PlanningContext;
import org.apache.ignite.internal.sql.engine.prepare.ddl.DdlOptionInfo;
import org.apache.ignite.internal.sql.engine.prepare.ddl.ZoneOptionEnum;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableAddColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterTableDropColumn;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterZoneRenameTo;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterZoneSet;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlAlterZoneSetDefault;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateSchema;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlCreateZone;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropIndex;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropSchema;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropSchemaBehavior;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropTable;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlDropZone;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlIndexType;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlPrimaryKeyConstraint;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlPrimaryKeyIndexType;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlTypeNameSpec;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlZoneOption;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.IgniteMath;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.SchemaNotFoundException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class DdlSqlToCommandConverter {
    private final Map<ZoneOptionEnum, DdlOptionInfo<CreateZoneCommandBuilder, ?>> zoneOptionInfos;
    private final Map<ZoneOptionEnum, DdlOptionInfo<AlterZoneCommandBuilder, ?>> alterZoneOptionInfos;
    private final Set<String> knownZoneOptionNames = EnumSet.allOf(ZoneOptionEnum.class).stream().map(Enum::name).collect(Collectors.toSet());

    public DdlSqlToCommandConverter() {
        this.zoneOptionInfos = new EnumMap<ZoneOptionEnum, DdlOptionInfo<CreateZoneCommandBuilder, String>>(Map.of(ZoneOptionEnum.REPLICAS, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::replicas), ZoneOptionEnum.PARTITIONS, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::partitions), ZoneOptionEnum.DISTRIBUTION_ALGORITHM, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, null, (builder, params) -> {}), ZoneOptionEnum.DATA_NODES_FILTER, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, null, CreateZoneCommandBuilder::filter), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::dataNodesAutoAdjust), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_UP, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::dataNodesAutoAdjustScaleUp), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_DOWN, new DdlOptionInfo<CreateZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, CreateZoneCommandBuilder::dataNodesAutoAdjustScaleDown), ZoneOptionEnum.STORAGE_PROFILES, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, this::checkEmptyString, (builder, params) -> builder.storageProfilesParams(DistributionZonesUtil.parseStorageProfiles((String)params))), ZoneOptionEnum.CONSISTENCY_MODE, new DdlOptionInfo<CreateZoneCommandBuilder, String>(String.class, this::checkEmptyString, (builder, params) -> builder.consistencyModeParams(DdlSqlToCommandConverter.parseConsistencyMode(params)))));
        this.alterZoneOptionInfos = new EnumMap<ZoneOptionEnum, DdlOptionInfo<AlterZoneCommandBuilder, Integer>>(Map.of(ZoneOptionEnum.REPLICAS, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::replicas), ZoneOptionEnum.PARTITIONS, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::partitions), ZoneOptionEnum.DATA_NODES_FILTER, new DdlOptionInfo<AlterZoneCommandBuilder, String>(String.class, null, AlterZoneCommandBuilder::filter), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::dataNodesAutoAdjust), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_UP, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::dataNodesAutoAdjustScaleUp), ZoneOptionEnum.DATA_NODES_AUTO_ADJUST_SCALE_DOWN, new DdlOptionInfo<AlterZoneCommandBuilder, Integer>(Integer.class, this::checkPositiveNumber, AlterZoneCommandBuilder::dataNodesAutoAdjustScaleDown)));
    }

    public static ConsistencyMode parseConsistencyMode(String consistencyMode) {
        try {
            return ConsistencyMode.valueOf((String)consistencyMode);
        }
        catch (IllegalArgumentException e) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to parse consistency mode: " + consistencyMode + ". Valid values are: " + Arrays.toString(ConsistencyMode.values()));
        }
    }

    public CatalogCommand convert(SqlDdl ddlNode, PlanningContext ctx) {
        if (ddlNode instanceof IgniteSqlCreateTable) {
            return this.convertCreateTable((IgniteSqlCreateTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropTable) {
            return this.convertDropTable((IgniteSqlDropTable)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableAddColumn) {
            return this.convertAlterTableAdd((IgniteSqlAlterTableAddColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterTableDropColumn) {
            return this.convertAlterTableDrop((IgniteSqlAlterTableDropColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterColumn) {
            return this.convertAlterColumn((IgniteSqlAlterColumn)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateIndex) {
            return this.convertAddIndex((IgniteSqlCreateIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropIndex) {
            return this.convertDropIndex((IgniteSqlDropIndex)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateZone) {
            return this.convertCreateZone((IgniteSqlCreateZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneRenameTo) {
            return this.convertAlterZoneRename((IgniteSqlAlterZoneRenameTo)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneSet) {
            return this.convertAlterZoneSet((IgniteSqlAlterZoneSet)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlAlterZoneSetDefault) {
            return this.convertAlterZoneSetDefault((IgniteSqlAlterZoneSetDefault)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropZone) {
            return this.convertDropZone((IgniteSqlDropZone)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlCreateSchema) {
            return this.convertCreateSchema((IgniteSqlCreateSchema)ddlNode, ctx);
        }
        if (ddlNode instanceof IgniteSqlDropSchema) {
            return this.convertDropSchema((IgniteSqlDropSchema)ddlNode, ctx);
        }
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported operation [sqlNodeKind=" + String.valueOf(ddlNode.getKind()) + "; querySql=\"" + ctx.query() + "\"]");
    }

    private CatalogCommand convertCreateSchema(IgniteSqlCreateSchema ddlNode, PlanningContext ctx) {
        return CreateSchemaCommand.builder().name(this.deriveObjectName(ddlNode.name(), ctx, "schemaName")).ifNotExists(ddlNode.ifNotExists()).build();
    }

    private CatalogCommand convertDropSchema(IgniteSqlDropSchema ddlNode, PlanningContext ctx) {
        return DropSchemaCommand.builder().name(this.deriveObjectName(ddlNode.name(), ctx, "schemaName")).ifExists(ddlNode.ifExists()).cascade(ddlNode.behavior() == IgniteSqlDropSchemaBehavior.CASCADE).build();
    }

    private CatalogCommand convertCreateTable(IgniteSqlCreateTable createTblNode, PlanningContext ctx) {
        TableHashPrimaryKey primaryKey;
        CreateTableCommandBuilder tblBuilder = CreateTableCommand.builder();
        List pkConstraints = createTblNode.columnList().getList().stream().filter(IgniteSqlPrimaryKeyConstraint.class::isInstance).map(IgniteSqlPrimaryKeyConstraint.class::cast).collect(Collectors.toList());
        for (SqlNode sqlNode : createTblNode.columnList().getList()) {
            String colName;
            if (!(sqlNode instanceof SqlColumnDeclaration) || !IgniteSqlValidator.isSystemFieldName(colName = ((SqlColumnDeclaration)sqlNode).name.getSimple())) continue;
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. Column '" + colName + "' is reserved name.");
        }
        if (pkConstraints.isEmpty() && Commons.implicitPkEnabled()) {
            SqlIdentifier colName = new SqlIdentifier("__p_key", SqlParserPos.ZERO);
            pkConstraints.add(new IgniteSqlPrimaryKeyConstraint(SqlParserPos.ZERO, null, SqlNodeList.of((SqlNode)colName), IgniteSqlPrimaryKeyIndexType.IMPLICIT_HASH));
            SqlIdentifier uuidTypeName = new SqlIdentifier("UUID", SqlParserPos.ZERO);
            SqlDataTypeSpec type = new SqlDataTypeSpec((SqlTypeNameSpec)new IgniteSqlTypeNameSpec(uuidTypeName, SqlParserPos.ZERO), SqlParserPos.ZERO);
            SqlNode col = SqlDdlNodes.column((SqlParserPos)SqlParserPos.ZERO, (SqlIdentifier)colName, (SqlDataTypeSpec)type, null, (ColumnStrategy)ColumnStrategy.DEFAULT);
            createTblNode.columnList().add(0, col);
        }
        if (pkConstraints.isEmpty()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Table without PRIMARY KEY is not supported");
        }
        if (pkConstraints.size() > 1) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected number of primary key constraints [expected at most one, but was " + pkConstraints.size() + "; querySql=\"" + ctx.query() + "\"]");
        }
        IgniteSqlPrimaryKeyConstraint pkConstraint = (IgniteSqlPrimaryKeyConstraint)((Object)pkConstraints.get(0));
        SqlNodeList columnNodes = pkConstraint.getColumnList();
        ArrayList<String> pkColumns = new ArrayList<String>(columnNodes.size());
        ArrayList<CatalogColumnCollation> pkCollations = new ArrayList<CatalogColumnCollation>(columnNodes.size());
        IgniteSqlPrimaryKeyIndexType pkIndexType = pkConstraint.getIndexType();
        boolean supportCollation = pkIndexType == IgniteSqlPrimaryKeyIndexType.SORTED;
        DdlSqlToCommandConverter.parseColumnList(pkConstraint.getColumnList(), pkColumns, pkCollations, supportCollation);
        switch (pkIndexType) {
            case SORTED: {
                primaryKey = TableSortedPrimaryKey.builder().columns(pkColumns).collations(pkCollations).build();
                break;
            }
            case HASH: 
            case IMPLICIT_HASH: {
                primaryKey = TableHashPrimaryKey.builder().columns(pkColumns).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected primary key index type: " + String.valueOf((Object)pkIndexType));
            }
        }
        List colocationColumns = createTblNode.colocationColumns() == null ? null : createTblNode.colocationColumns().getList().stream().map(SqlIdentifier.class::cast).map(SqlIdentifier::getSimple).collect(Collectors.toList());
        List colDeclarations = createTblNode.columnList().getList().stream().filter(SqlColumnDeclaration.class::isInstance).map(SqlColumnDeclaration.class::cast).collect(Collectors.toList());
        ArrayList<ColumnParams> columns = new ArrayList<ColumnParams>(colDeclarations.size());
        for (SqlColumnDeclaration col : colDeclarations) {
            if (!col.name.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of columnName [expected a simple identifier, but was " + String.valueOf(col.name) + "; querySql=\"" + ctx.query() + "\"]");
            }
            columns.add(DdlSqlToCommandConverter.convertColumnDeclaration(col, ctx.planner(), !pkColumns.contains(col.name.getSimple())));
        }
        String storageProfile = null;
        if (createTblNode.storageProfile() != null) {
            assert (createTblNode.storageProfile().getKind() == SqlKind.LITERAL);
            storageProfile = (String)((SqlLiteral)createTblNode.storageProfile()).getValueAs(String.class);
            this.checkEmptyString(storageProfile);
        }
        String zone = createTblNode.zone() == null ? null : createTblNode.zone().getSimple();
        return ((CreateTableCommandBuilder)((CreateTableCommandBuilder)((CreateTableCommandBuilder)tblBuilder.schemaName(this.deriveSchemaName(createTblNode.name(), ctx))).tableName(this.deriveObjectName(createTblNode.name(), ctx, "tableName"))).columns(columns).primaryKey((TablePrimaryKey)primaryKey).colocationColumns(colocationColumns).zone(zone).storageProfile(storageProfile).ifTableExists(createTblNode.ifNotExists())).build();
    }

    private static ColumnParams convertColumnDeclaration(SqlColumnDeclaration col, IgnitePlanner planner, boolean nullable) {
        assert (col.name.isSimple());
        String name = col.name.getSimple();
        RelDataType relType = planner.convert(col.dataType, nullable);
        if (SqlTypeUtil.isInterval((RelDataType)relType)) {
            String error = IgniteStringFormatter.format((String)"Type {} cannot be used in a column definition [column={}].", (Object[])new Object[]{relType.getSqlTypeName().getSpaceName(), name});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, error);
        }
        ColumnTypeParams typeParams = new ColumnTypeParams(relType);
        return ColumnParams.builder().name(name).type(typeParams.colType).nullable(relType.isNullable()).precision(typeParams.precision).scale(typeParams.scale).length(typeParams.length).defaultValue(DdlSqlToCommandConverter.convertDefault(col.expression, relType, name)).build();
    }

    private static DefaultValue convertDefault(@Nullable SqlNode expression, RelDataType relType, String name) {
        if (expression == null) {
            return DefaultValue.constant(null);
        }
        if (expression instanceof SqlIdentifier) {
            return DefaultValue.functionCall((String)((SqlIdentifier)expression).getSimple());
        }
        if (expression instanceof SqlLiteral) {
            ColumnType columnType = TypeUtils.columnType(relType);
            Object val = DdlSqlToCommandConverter.fromLiteral(columnType, name, (SqlLiteral)expression, relType.getPrecision(), relType.getScale());
            return DefaultValue.constant((Object)val);
        }
        throw new IllegalArgumentException("Unsupported default expression: " + String.valueOf(expression.getKind()));
    }

    private CatalogCommand convertAlterTableAdd(IgniteSqlAlterTableAddColumn alterTblNode, PlanningContext ctx) {
        AlterTableAddColumnCommandBuilder builder = AlterTableAddColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        builder.ifTableExists(alterTblNode.ifExists());
        ArrayList<ColumnParams> columns = new ArrayList<ColumnParams>(alterTblNode.columns().size());
        for (SqlNode colNode : alterTblNode.columns()) {
            assert (colNode instanceof SqlColumnDeclaration) : colNode.getClass();
            SqlColumnDeclaration col = (SqlColumnDeclaration)colNode;
            Boolean nullable = col.dataType.getNullable();
            String colName = col.name.getSimple();
            if (IgniteSqlValidator.isSystemFieldName(colName)) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Failed to validate query. Column '" + colName + "' is reserved name.");
            }
            columns.add(DdlSqlToCommandConverter.convertColumnDeclaration(col, ctx.planner(), nullable != null ? nullable : true));
        }
        builder.columns(columns);
        return builder.build();
    }

    private CatalogCommand convertAlterColumn(IgniteSqlAlterColumn alterColumnNode, PlanningContext ctx) {
        Boolean notNull;
        AlterTableAlterColumnCommandBuilder builder = AlterTableAlterColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterColumnNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterColumnNode.name(), ctx, "table name"));
        builder.ifTableExists(alterColumnNode.ifExists());
        builder.columnName(alterColumnNode.columnName().getSimple());
        RelDataType relType = null;
        SqlDataTypeSpec colTypeSpec = alterColumnNode.dataType();
        if (colTypeSpec != null) {
            relType = ctx.planner().convert(colTypeSpec, true);
            ColumnTypeParams typeParams = new ColumnTypeParams(relType);
            builder.type(typeParams.colType);
            if (typeParams.length != null) {
                builder.length(typeParams.length.intValue());
            } else {
                if (typeParams.precision != null) {
                    builder.precision(typeParams.precision.intValue());
                }
                if (typeParams.scale != null) {
                    builder.scale(typeParams.scale.intValue());
                }
            }
        }
        if ((notNull = alterColumnNode.notNull()) != null) {
            builder.nullable(notNull == false);
        }
        if (alterColumnNode.expression() != null) {
            SqlNode expr = alterColumnNode.expression();
            int precision = relType == null ? -1 : relType.getPrecision();
            int scale = relType == null ? Integer.MIN_VALUE : relType.getScale();
            String name = alterColumnNode.columnName().getSimple();
            if (!(expr instanceof SqlLiteral)) {
                throw new IllegalStateException("Invalid expression type " + String.valueOf(expr.getKind()));
            }
            DeferredDefaultValue resolveDfltFunc = type -> DefaultValue.constant((Object)DdlSqlToCommandConverter.fromLiteral(type, name, (SqlLiteral)expr, precision, scale));
            builder.deferredDefaultValue(resolveDfltFunc);
        }
        return builder.build();
    }

    private CatalogCommand convertAlterTableDrop(IgniteSqlAlterTableDropColumn alterTblNode, PlanningContext ctx) {
        AlterTableDropColumnCommandBuilder builder = AlterTableDropColumnCommand.builder();
        builder.schemaName(this.deriveSchemaName(alterTblNode.name(), ctx));
        builder.tableName(this.deriveObjectName(alterTblNode.name(), ctx, "table name"));
        builder.ifTableExists(alterTblNode.ifExists());
        HashSet cols = new HashSet(alterTblNode.columns().size());
        alterTblNode.columns().forEach(c -> cols.add(((SqlIdentifier)c).getSimple()));
        builder.columns(cols);
        return builder.build();
    }

    private CatalogCommand convertDropTable(IgniteSqlDropTable dropTblNode, PlanningContext ctx) {
        DropTableCommandBuilder builder = DropTableCommand.builder();
        return ((DropTableCommandBuilder)((DropTableCommandBuilder)((DropTableCommandBuilder)builder.schemaName(this.deriveSchemaName(dropTblNode.name(), ctx))).tableName(this.deriveObjectName(dropTblNode.name(), ctx, "tableName"))).ifTableExists(dropTblNode.ifExists)).build();
    }

    private CatalogCommand convertAddIndex(IgniteSqlCreateIndex sqlCmd, PlanningContext ctx) {
        boolean sortedIndex = sqlCmd.type() == IgniteSqlIndexType.SORTED || sqlCmd.type() == IgniteSqlIndexType.IMPLICIT_SORTED;
        SqlNodeList columnList = sqlCmd.columnList();
        ArrayList<String> columns = new ArrayList<String>(columnList.size());
        ArrayList<CatalogColumnCollation> collations = new ArrayList<CatalogColumnCollation>(columnList.size());
        DdlSqlToCommandConverter.parseColumnList(columnList, columns, collations, sortedIndex);
        if (sortedIndex) {
            return ((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)((CreateSortedIndexCommandBuilder)CreateSortedIndexCommand.builder().schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx))).tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, "table name"))).ifNotExists(sqlCmd.ifNotExists())).indexName(sqlCmd.indexName().getSimple())).columns(columns)).collations(collations).build();
        }
        return ((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)((CreateHashIndexCommandBuilder)CreateHashIndexCommand.builder().schemaName(this.deriveSchemaName(sqlCmd.tableName(), ctx))).tableName(this.deriveObjectName(sqlCmd.tableName(), ctx, "table name"))).ifNotExists(sqlCmd.ifNotExists())).indexName(sqlCmd.indexName().getSimple())).columns(columns)).build();
    }

    private static void parseColumnList(SqlNodeList columnList, List<String> columns, List<CatalogColumnCollation> collations, boolean supportCollation) {
        for (SqlNode col : columnList.getList()) {
            boolean asc = true;
            if (col.getKind() == SqlKind.DESCENDING) {
                col = (SqlNode)((SqlCall)col).getOperandList().get(0);
                asc = false;
            }
            String columnName = ((SqlIdentifier)col).getSimple();
            columns.add(columnName);
            if (!supportCollation) continue;
            collations.add(CatalogColumnCollation.get((boolean)asc, (!asc ? 1 : 0) != 0));
        }
    }

    private CatalogCommand convertDropIndex(IgniteSqlDropIndex sqlCmd, PlanningContext ctx) {
        String schemaName = this.deriveSchemaName(sqlCmd.indexName(), ctx);
        String indexName = this.deriveObjectName(sqlCmd.indexName(), ctx, "index name");
        return ((DropIndexCommandBuilder)((DropIndexCommandBuilder)DropIndexCommand.builder().schemaName(schemaName)).indexName(indexName)).ifExists(sqlCmd.ifExists()).build();
    }

    private CatalogCommand convertCreateZone(IgniteSqlCreateZone createZoneNode, PlanningContext ctx) {
        CreateZoneCommandBuilder builder = CreateZoneCommand.builder();
        builder.zoneName(this.deriveObjectName(createZoneNode.name(), ctx, "zoneName"));
        builder.ifNotExists(createZoneNode.ifNotExists());
        if (createZoneNode.createOptionList() == null) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, String.valueOf((Object)ZoneOptionEnum.STORAGE_PROFILES) + " option cannot be null");
        }
        HashSet<String> remainingKnownOptions = new HashSet<String>(this.knownZoneOptionNames);
        for (SqlNode optionNode : createZoneNode.createOptionList().getList()) {
            IgniteSqlZoneOption option = (IgniteSqlZoneOption)optionNode;
            assert (option.key().isSimple()) : option.key();
            String optionName = option.key().getSimple().toUpperCase();
            DdlOptionInfo<CreateZoneCommandBuilder, ?> zoneOptionInfo = null;
            if (remainingKnownOptions.remove(optionName)) {
                zoneOptionInfo = this.zoneOptionInfos.get((Object)ZoneOptionEnum.valueOf(optionName));
            } else if (this.knownZoneOptionNames.contains(optionName)) {
                throw DdlSqlToCommandConverter.duplicateZoneOption(ctx, optionName);
            }
            if (zoneOptionInfo == null) {
                throw DdlSqlToCommandConverter.unexpectedZoneOption(ctx, optionName);
            }
            this.updateCommandOption("Zone", optionName, option.value(), zoneOptionInfo, ctx.query(), builder);
        }
        if (remainingKnownOptions.contains(ZoneOptionEnum.STORAGE_PROFILES.name())) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, String.valueOf((Object)ZoneOptionEnum.STORAGE_PROFILES) + " option cannot be null");
        }
        return builder.build();
    }

    private CatalogCommand convertAlterZoneSet(IgniteSqlAlterZoneSet alterZoneSet, PlanningContext ctx) {
        AlterZoneCommandBuilder builder = AlterZoneCommand.builder();
        builder.zoneName(this.deriveObjectName(alterZoneSet.name(), ctx, "zoneName"));
        builder.ifExists(alterZoneSet.ifExists());
        HashSet<String> remainingKnownOptions = new HashSet<String>(this.knownZoneOptionNames);
        for (SqlNode optionNode : alterZoneSet.alterOptionsList().getList()) {
            IgniteSqlZoneOption option = (IgniteSqlZoneOption)optionNode;
            String optionName = option.key().getSimple().toUpperCase();
            if (!this.knownZoneOptionNames.contains(optionName)) {
                throw DdlSqlToCommandConverter.unexpectedZoneOption(ctx, optionName);
            }
            if (!remainingKnownOptions.remove(optionName)) {
                throw DdlSqlToCommandConverter.duplicateZoneOption(ctx, optionName);
            }
            DdlOptionInfo<AlterZoneCommandBuilder, ?> zoneOptionInfo = this.alterZoneOptionInfos.get((Object)ZoneOptionEnum.valueOf(optionName));
            assert (zoneOptionInfo != null) : optionName;
            assert (option.value() instanceof SqlLiteral) : option.value();
            this.updateCommandOption("Zone", optionName, option.value(), zoneOptionInfo, ctx.query(), builder);
        }
        return builder.build();
    }

    private CatalogCommand convertAlterZoneSetDefault(IgniteSqlAlterZoneSetDefault alterZoneSetDefault, PlanningContext ctx) {
        return AlterZoneSetDefaultCommand.builder().zoneName(this.deriveObjectName(alterZoneSetDefault.name(), ctx, "zoneName")).ifExists(alterZoneSetDefault.ifExists()).build();
    }

    private CatalogCommand convertAlterZoneRename(IgniteSqlAlterZoneRenameTo alterZoneRename, PlanningContext ctx) {
        return ((RenameZoneCommandBuilder)RenameZoneCommand.builder().zoneName(this.deriveObjectName(alterZoneRename.name(), ctx, "zoneName"))).newZoneName(alterZoneRename.newName().getSimple()).ifExists(alterZoneRename.ifExists()).build();
    }

    private CatalogCommand convertDropZone(IgniteSqlDropZone dropZoneNode, PlanningContext ctx) {
        return ((DropZoneCommandBuilder)DropZoneCommand.builder().zoneName(this.deriveObjectName(dropZoneNode.name(), ctx, "zoneName"))).ifExists(dropZoneNode.ifExists()).build();
    }

    private String deriveSchemaName(SqlIdentifier id, PlanningContext ctx) {
        String schemaName;
        if (id.isSimple()) {
            schemaName = ctx.schemaName();
        } else {
            SqlIdentifier schemaId = id.skipLast(1);
            if (!schemaId.isSimple()) {
                throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of schemaName [expected a simple identifier, but was " + String.valueOf(schemaId) + "; querySql=\"" + ctx.query() + "\"]");
            }
            schemaName = schemaId.getSimple();
        }
        if (ctx.catalogReader().getRootSchema().getSubSchema(schemaName, true) == null) {
            throw new SchemaNotFoundException(schemaName);
        }
        return schemaName;
    }

    private String deriveObjectName(SqlIdentifier id, PlanningContext ctx, String objDesc) {
        if (id.isSimple()) {
            return id.getSimple();
        }
        SqlIdentifier objId = id.getComponent(id.skipLast((int)1).names.size());
        if (!objId.isSimple()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unexpected value of " + objDesc + " [expected a simple identifier, but was " + String.valueOf(objId) + "; querySql=\"" + ctx.query() + "\"]");
        }
        return objId.getSimple();
    }

    private <S, T> void updateCommandOption(String sqlObjName, Object optId, SqlNode value, DdlOptionInfo<S, T> optInfo, String query, S target) {
        T expectedValue = DdlSqlToCommandConverter.extractValueForUpdateCommandOption(sqlObjName, optId, value, optInfo, query);
        DdlSqlToCommandConverter.validateValue(sqlObjName, optId, optInfo, query, expectedValue);
        optInfo.setter.accept(target, expectedValue);
    }

    private static <T, S> T extractValueForUpdateCommandOption(String sqlObjName, Object optId, SqlNode value, DdlOptionInfo<S, T> optInfo, String query) {
        SqlKind valueKind = value.getKind();
        switch (valueKind) {
            case IDENTIFIER: {
                return (T)((SqlIdentifier)value).getSimple();
            }
            case LITERAL: {
                return DdlSqlToCommandConverter.valueFromLiteralAccordingToOptionType(sqlObjName, optId, optInfo, query, (SqlLiteral)value);
            }
        }
        String msg = IgniteStringFormatter.format((String)"Invalid {} value kind [kind={}, expectedKind=(IDENTIFIER, LITERAL), query={}]", (Object[])new Object[]{sqlObjName.toLowerCase(), valueKind, query});
        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg);
    }

    private static <S, T> void validateValue(String sqlObjName, Object optId, DdlOptionInfo<S, T> optInfo, String query, T expectedValue) {
        if (optInfo.validator == null) {
            return;
        }
        try {
            optInfo.validator.accept(expectedValue);
        }
        catch (Throwable e) {
            String msg = IgniteStringFormatter.format((String)"{} option validation failed [option={}, err={}, query={}]", (Object[])new Object[]{sqlObjName, optId, e.getMessage(), query});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg, e);
        }
    }

    private static <T, S> T valueFromLiteralAccordingToOptionType(String sqlObjName, Object optId, DdlOptionInfo<S, T> optInfo, String query, SqlLiteral literalValue) {
        try {
            return (T)literalValue.getValueAs(optInfo.type);
        }
        catch (Throwable cause) {
            String msg = IgniteStringFormatter.format((String)"Invalid {} option type [option={}, expectedType={}, query={}]", (Object[])new Object[]{sqlObjName.toLowerCase(), optId, optInfo.type.getSimpleName(), query});
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, msg, cause);
        }
    }

    private void checkPositiveNumber(int num) {
        if (num < 0) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Must be positive:" + num);
        }
    }

    private void checkEmptyString(String string) {
        if (string.isBlank()) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "String cannot be empty");
        }
    }

    @Nullable
    private static Object fromLiteral(ColumnType columnType, String name, SqlLiteral literal, int precision, int scale) {
        if (literal.getValue() == null) {
            return null;
        }
        try {
            switch (columnType) {
                case PERIOD: {
                    if (!(literal instanceof SqlIntervalLiteral)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression is not belongs to interval type");
                    }
                    String strValue = Objects.requireNonNull(literal.toValue());
                    SqlNumericLiteral numLiteral = SqlLiteral.createExactNumeric((String)strValue, (SqlParserPos)literal.getParserPosition());
                    int val = numLiteral.intValue(true);
                    SqlIntervalLiteral literal0 = (SqlIntervalLiteral)literal;
                    SqlIntervalQualifier qualifier = ((SqlIntervalLiteral.IntervalValue)literal0.getValue()).getIntervalQualifier();
                    if (qualifier.typeName() == SqlTypeName.INTERVAL_YEAR) {
                        val *= 12;
                    }
                    return TypeUtils.fromInternal(val, Period.class);
                }
                case DURATION: {
                    if (!(literal instanceof SqlIntervalLiteral)) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression is not belongs to interval type");
                    }
                    String strValue = Objects.requireNonNull(literal.toValue());
                    SqlNumericLiteral numLiteral = SqlLiteral.createExactNumeric((String)strValue, (SqlParserPos)literal.getParserPosition());
                    long val = numLiteral.longValue(true);
                    SqlIntervalLiteral literal0 = (SqlIntervalLiteral)literal;
                    SqlIntervalQualifier qualifier = ((SqlIntervalLiteral.IntervalValue)literal0.getValue()).getIntervalQualifier();
                    if (qualifier.typeName() == SqlTypeName.INTERVAL_DAY) {
                        val = Duration.ofDays(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_HOUR) {
                        val = Duration.ofHours(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_MINUTE) {
                        val = Duration.ofMinutes(val).toMillis();
                    } else if (qualifier.typeName() == SqlTypeName.INTERVAL_SECOND) {
                        val = Duration.ofSeconds(val).toMillis();
                    }
                    return TypeUtils.fromInternal(val, Duration.class);
                }
                case STRING: {
                    String val = literal.toValue();
                    if (precision != -1 && Objects.requireNonNull(val).length() > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Value too long for type character({})", (Object[])new Object[]{precision}));
                    }
                    return val;
                }
                case UUID: {
                    return UUID.fromString(Objects.requireNonNull(literal.toValue()));
                }
                case DATE: {
                    try {
                        literal = SqlParserUtil.parseDateLiteral((String)((String)literal.getValueAs(String.class)), (SqlParserPos)literal.getParserPosition());
                        int val = ((DateString)literal.getValueAs(DateString.class)).getDaysSinceEpoch();
                        return TypeUtils.fromInternal(val, LocalDate.class);
                    }
                    catch (CalciteContextException e) {
                        literal = SqlParserUtil.parseTimestampLiteral((String)((String)literal.getValueAs(String.class)), (SqlParserPos)literal.getParserPosition());
                        TimestampString tsString = (TimestampString)literal.getValueAs(TimestampString.class);
                        int val = IgniteMath.convertToIntExact(TimeUnit.MILLISECONDS.toDays(tsString.getMillisSinceEpoch()));
                        return TypeUtils.fromInternal(val, LocalDate.class);
                    }
                }
                case TIME: {
                    String strLiteral = ((String)literal.getValueAs(String.class)).trim();
                    int pos = strLiteral.indexOf(32);
                    if (pos != -1) {
                        strLiteral = strLiteral.substring(pos);
                    }
                    literal = SqlParserUtil.parseTimeLiteral((String)strLiteral, (SqlParserPos)literal.getParserPosition());
                    int val = ((TimeString)literal.getValueAs(TimeString.class)).getMillisOfDay();
                    return TypeUtils.fromInternal(val, LocalTime.class);
                }
                case DATETIME: {
                    literal = SqlParserUtil.parseTimestampLiteral((String)((String)literal.getValueAs(String.class)), (SqlParserPos)literal.getParserPosition());
                    TimestampString tsString = (TimestampString)literal.getValueAs(TimestampString.class);
                    return TypeUtils.fromInternal(tsString.getMillisSinceEpoch(), LocalDateTime.class);
                }
                case TIMESTAMP: {
                    throw new UnsupportedOperationException("Type is not supported: " + String.valueOf(columnType));
                }
                case INT32: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToIntExact(val);
                }
                case INT64: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    BigDecimal val = literal.bigDecimalValue();
                    return Objects.requireNonNull(val).longValueExact();
                }
                case INT16: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToShortExact(val);
                }
                case INT8: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    long val = literal.longValue(true);
                    return IgniteMath.convertToByteExact(val);
                }
                case DECIMAL: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    BigDecimal val = (BigDecimal)literal.getValueAs(BigDecimal.class);
                    val = val.setScale(scale, RoundingMode.HALF_UP);
                    if (val.precision() > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Numeric field overflow for type decimal({}, {})", (Object[])new Object[]{precision, scale}));
                    }
                    return val;
                }
                case DOUBLE: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    return literal.getValueAs(Double.class);
                }
                case FLOAT: {
                    DdlSqlToCommandConverter.acceptNumericLiteral(literal, columnType);
                    return literal.getValueAs(Float.class);
                }
                case BYTE_ARRAY: {
                    byte[] arr = (byte[])literal.getValueAs(byte[].class);
                    if (precision != -1 && Objects.requireNonNull(arr).length > precision) {
                        throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Value too long for type binary({})", (Object[])new Object[]{precision}));
                    }
                    return arr;
                }
                case BOOLEAN: {
                    return literal.getValueAs(Boolean.class);
                }
            }
            throw new IllegalStateException("Unknown type [type=" + String.valueOf(columnType) + "]");
        }
        catch (Throwable th) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Invalid default value for column '{}'", (Object[])new Object[]{name}), th);
        }
    }

    private static void acceptNumericLiteral(SqlLiteral literal, ColumnType columnType) {
        if (!(literal instanceof SqlNumericLiteral)) {
            throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Default expression can`t be applied to type " + String.valueOf(columnType));
        }
    }

    private static IgniteException unexpectedZoneOption(PlanningContext ctx, String optionName) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Unexpected zone option [option={}, query={}]", (Object[])new Object[]{optionName, ctx.query()}));
    }

    private static IgniteException duplicateZoneOption(PlanningContext ctx, String optionName) {
        return new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Duplicate zone option has been specified [option={}, query={}]", (Object[])new Object[]{optionName, ctx.query()}));
    }

    static class ColumnTypeParams {
        final ColumnType colType;
        @Nullable
        Integer precision = null;
        @Nullable
        Integer scale = null;
        @Nullable
        Integer length = null;

        ColumnTypeParams(RelDataType relType) {
            this.colType = TypeUtils.columnType(relType);
            if (this.colType.lengthAllowed()) {
                this.length = relType.getPrecision() == -1 ? CatalogUtils.defaultLength((ColumnType)this.colType, (int)1) : relType.getPrecision();
            } else {
                if (relType.getSqlTypeName().allowsPrec() && relType.getPrecision() != -1) {
                    this.precision = relType.getPrecision();
                }
                if (relType.getSqlTypeName().allowsScale() && relType.getScale() != Integer.MIN_VALUE) {
                    this.scale = relType.getScale();
                }
            }
        }
    }
}

