/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.deployunit.InitialDeployMode;
import org.apache.ignite.internal.deployunit.exception.InvalidNodesArgumentException;
import org.apache.ignite.network.ClusterNode;

public class NodesToDeploy {
    private final List<String> nodesList;
    private final InitialDeployMode deployMode;

    public NodesToDeploy(List<String> nodesList) {
        this(null, nodesList);
    }

    public NodesToDeploy(InitialDeployMode deployMode) {
        this(deployMode, null);
    }

    private NodesToDeploy(InitialDeployMode deployMode, List<String> nodesList) {
        this.deployMode = deployMode;
        this.nodesList = nodesList;
    }

    public CompletableFuture<Set<String>> extractNodes(ClusterManagementGroupManager cmgManager) {
        return this.nodesList != null ? this.extractNodesFromList(cmgManager) : this.extractNodesFromMode(cmgManager);
    }

    private CompletableFuture<Set<String>> extractNodesFromMode(ClusterManagementGroupManager cmgManager) {
        switch (this.deployMode) {
            case ALL: {
                return cmgManager.logicalTopology().thenApply(snapshot -> snapshot.nodes().stream().map(ClusterNode::name).collect(Collectors.toUnmodifiableSet()));
            }
        }
        return cmgManager.majority();
    }

    private CompletableFuture<Set<String>> extractNodesFromList(ClusterManagementGroupManager cmgManager) {
        return cmgManager.majority().thenCompose(majority -> ((CompletableFuture)cmgManager.logicalTopology().thenApply(snapshot -> snapshot.nodes().stream().map(ClusterNode::name).collect(Collectors.toUnmodifiableSet()))).thenApply(allNodes -> {
            HashSet<String> result = new HashSet<String>((Collection<String>)majority);
            for (String node : this.nodesList) {
                if (!allNodes.contains(node)) {
                    throw new InvalidNodesArgumentException("Node \"" + node + "\" is not present in the logical topology");
                }
                result.add(node);
            }
            return result;
        }));
    }

    public String toString() {
        return "NodesToDeploy{nodesList=" + String.valueOf(this.nodesList) + ", deployMode=" + String.valueOf((Object)this.deployMode) + "}";
    }
}

