/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.service;

import java.util.List;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class CommittedConfiguration {
    private final long index;
    private final long term;
    @IgniteToStringInclude
    private final List<String> peers;
    @IgniteToStringInclude
    private final List<String> learners;
    @IgniteToStringInclude
    @Nullable
    private final List<String> oldPeers;
    @IgniteToStringInclude
    @Nullable
    private final List<String> oldLearners;

    public CommittedConfiguration(long index, long term, List<String> peers, List<String> learners, @Nullable List<String> oldPeers, @Nullable List<String> oldLearners) {
        this.index = index;
        this.term = term;
        this.peers = List.copyOf(peers);
        this.learners = List.copyOf(learners);
        this.oldPeers = oldPeers == null ? null : List.copyOf(oldPeers);
        this.oldLearners = oldLearners == null ? null : List.copyOf(oldLearners);
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public List<String> peers() {
        return this.peers;
    }

    public List<String> learners() {
        return this.learners;
    }

    @Nullable
    public List<String> oldPeers() {
        return this.oldPeers;
    }

    @Nullable
    public List<String> oldLearners() {
        return this.oldLearners;
    }

    public String toString() {
        return S.toString(CommittedConfiguration.class, (Object)this);
    }
}

