/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft;

import java.util.Objects;
import org.apache.ignite.internal.raft.Peer;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.tostring.S;

public class RaftNodeId {
    private final ReplicationGroupId groupId;
    private final Peer peer;

    public RaftNodeId(ReplicationGroupId groupId, Peer peer) {
        this.groupId = groupId;
        this.peer = Objects.requireNonNull(peer);
    }

    public String nodeIdStringForStorage() {
        return this.groupId().toString() + "-" + this.peer().idx();
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    public Peer peer() {
        return this.peer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RaftNodeId that = (RaftNodeId)o;
        if (!this.groupId.equals((Object)that.groupId)) {
            return false;
        }
        return this.peer.equals(that.peer);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.peer.hashCode();
        return result;
    }

    public String toString() {
        return S.toString(RaftNodeId.class, (Object)this);
    }
}

